/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC19
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC19.class);
    public static final transient String CTRL_ID = "REC19";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String bord_nodeId = null;
    private String ligne_nodeId = null;
    private Vector<Node> anonodes = new Vector();
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String FIN_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String ligne_IdLigne = "";
    private String ligne_Mtht = "";
    private String ligne_Mttva = "";
    private String ligne_Txtva = "";
    private String ligne_Mtht_nodeid = "";
    private String ligne_Mttva_nodeid = "";
    private String ligne_Txtva_nodeid = "";
    private StringBuffer buff = null;
    private boolean bloquant = false;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_PIECE_DETAIL = "##DETAIL_MSG##";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String CHEMIN_INFOLIGNEPIECE_MTHT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtHT/";
    private static final String CHEMIN_INFOLIGNEPIECE_MTTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA/";
    private static final String CHEMIN_INFOLIGNEPIECE_TXTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/TxTva/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC19");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.anos = new Vector();
            this.anonodes = new Vector();
            this.piece_IdPce = "";
            this.buff = new StringBuffer();
            this.bloquant = false;
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
            this.ligne_Txtva = "";
            this.ligne_Mttva = "";
            this.ligne_Mtht = "";
            this.ligne_IdLigne = "";
            this.ligne_nodeId = atts.getValue("ano:node-id");
            this.ligne_Txtva_nodeid = "";
            this.ligne_Mttva_nodeid = "";
            this.ligne_Mtht_nodeid = "";
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTHT)) {
            this.ligne_Mtht = atts.getValue("V");
            this.ligne_Mtht_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTTVA)) {
            this.ligne_Mttva = atts.getValue("V");
            this.ligne_Mttva_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_TXTVA)) {
            this.ligne_Txtva = atts.getValue("V");
            this.ligne_Txtva_nodeid = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(FIN_LIGNEPIECE)) {
            double taux;
            String strTx;
            String[] les_taux = (String[])this.hParams.get("tauxTVA");
            double mtHT = -1.0;
            double mtTVA = -1.0;
            double txTVA = -1.0;
            if (this.ligne_Mtht != null && !"".equals(this.ligne_Mtht)) {
                try {
                    mtHT = Double.parseDouble(this.ligne_Mtht);
                }
                catch (Exception e) {
                    mtHT = -1.0;
                }
            }
            if (this.ligne_Mttva != null && !"".equals(this.ligne_Mttva)) {
                try {
                    mtTVA = Double.parseDouble(this.ligne_Mttva);
                }
                catch (Exception e) {
                    mtTVA = -1.0;
                }
            }
            if (this.ligne_Txtva != null && !"".equals(this.ligne_Txtva)) {
                try {
                    txTVA = Double.parseDouble(this.ligne_Txtva) / 100.0;
                }
                catch (Exception e) {
                    txTVA = -1.0;
                }
            }
            if (txTVA != -1.0) {
                double taux2;
                if (!this.contains(les_taux, this.ligne_Txtva)) {
                    this.anonodes.add(new Node(this.ligne_Txtva_nodeid));
                    this.buff.append("&lt;li&gt;ligne n\u00b0").append(this.ligne_IdLigne).append(" - MtHT=").append(this.ligne_Mtht).append(" - MtTVA=").append(this.ligne_Mttva).append(" - TxTVA=").append(this.ligne_Txtva).append("&lt;/li&gt;");
                    if (mtTVA != 0.0 && txTVA != 0.0) {
                        this.bloquant = true;
                    }
                } else if (mtHT != -1.0 && mtTVA != -1.0 && ((taux2 = mtTVA / mtHT) < this.txMinor(txTVA) || taux2 > this.txMajor(txTVA))) {
                    this.anonodes.add(new Node(this.ligne_Mtht_nodeid));
                    this.anonodes.add(new Node(this.ligne_Mttva_nodeid));
                    this.anonodes.add(new Node(this.ligne_Txtva_nodeid));
                    this.buff.append("&lt;li&gt;ligne n\u00b0").append(this.ligne_IdLigne).append(" - MtHT=").append(this.ligne_Mtht).append(" - MtTVA=").append(this.ligne_Mttva).append(" - TxTVA=").append(this.ligne_Txtva).append("&lt;/li&gt;");
                    if (mtTVA != 0.0 && txTVA != 0.0) {
                        this.bloquant = true;
                    }
                }
            } else if (mtHT != -1.0 && mtTVA != -1.0 && !this.containsMajoMino(les_taux, strTx = Double.toString(taux = mtTVA / mtHT))) {
                this.anonodes.add(new Node(this.ligne_Mtht_nodeid));
                this.anonodes.add(new Node(this.ligne_Mttva_nodeid));
                this.buff.append("&lt;li&gt;ligne n\u00b0").append(this.ligne_IdLigne).append(" - MtHT=").append(this.ligne_Mtht).append(" - MtTVA=").append(this.ligne_Mttva).append(" - TxTVA=").append(this.ligne_Txtva).append("&lt;/li&gt;");
                if (mtTVA != 0.0 && txTVA != 0.0) {
                    this.bloquant = true;
                }
            }
            return null;
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            if (this.anonodes.size() > 0) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_PIECE_DETAIL, this.buff.toString());
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.bloquant ? "BLOQUANT" : "NON BLOQUANT", path, xslParams);
                ano.addAll(this.anonodes);
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    private boolean contains(String[] tab, String val) {
        if (val == null || val.length() == 0) {
            return true;
        }
        if (tab == null || tab.length == 0) {
            return false;
        }
        double dVal = Double.parseDouble(val);
        for (String el : tab) {
            double dEl = Double.parseDouble(el);
            if (dEl != dVal) continue;
            return true;
        }
        return false;
    }

    private boolean containsMajoMino(String[] tab, String val) {
        if (val == null || val.length() == 0) {
            return true;
        }
        if (tab == null || tab.length == 0) {
            return false;
        }
        double dVal = Double.valueOf(val);
        for (String el : tab) {
            try {
                double tx = Double.valueOf(el) / 100.0;
                double marge_erreur = tx / 100.0;
                if (!(dVal >= tx - marge_erreur) || !(dVal <= tx + marge_erreur)) continue;
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private double txMinor(double tx) {
        double marge_erreur = tx / 100.0;
        return tx - marge_erreur;
    }

    private double txMajor(double tx) {
        double marge_erreur = tx / 100.0;
        return tx + marge_erreur;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

