/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC06
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC06.class);
    public static final transient String CTRL_ID = "REC06";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String bord_nodeId = null;
    private String ligne_nodeId = null;
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/";
    private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_typBord = "";
    private String bord_nbrpce = "";
    private String bord_nbrpce_nodeid = "";
    private int compteurPiece = 0;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_NBPCE = "#BORD_NBPCE#";
    private static final String MSG_NB_PIECES = "#NB_PIECES#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_NBRPCE = "/PES_RecetteAller/Bordereau/BlocBordereau/NbrPce/";
    private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC06");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_nbrpce_nodeid = "";
            this.bord_nbrpce = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.compteurPiece = 0;
            this.bord_nodeId = atts.getValue("ano:node-id");
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_typBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_NBRPCE)) {
            this.bord_nbrpce = atts.getValue("V");
            this.bord_nbrpce_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_PIECE)) {
            ++this.compteurPiece;
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/")) {
            boolean err = false;
            Vector anonodes = new Vector();
            try {
                if (this.bord_nbrpce != null && !"".equals(this.bord_nbrpce)) {
                    int nbBordPce = Integer.parseInt(this.bord_nbrpce);
                    err = nbBordPce != this.compteurPiece;
                }
            }
            catch (Exception e) {
                err = true;
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_NBPCE, this.bord_nbrpce);
                msg = msg.replaceAll(MSG_NB_PIECES, String.valueOf(this.compteurPiece));
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_typBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Bordereau");
                xslParams.put("mandatId", "");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.bord_nbrpce_nodeid));
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

