/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEP09
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static Logger logger = Logger.getLogger(DEP09.class);
    public static final transient String CTRL_ID = "DEP09";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String bord_nodeId = null;
    private String piece_nodeId = null;
    private static final String BLOQUANT = "BLOQUANT";
    private static final String NON_BLOQUANT = "NON BLOQUANT";
    private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/Piece/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_TypPce = "";
    private String piece_NatPce = "";
    private String codeNature = "";
    private String idLigne = "";
    private boolean suiviDGP = false;
    private String baliseDgp = "";
    private boolean dgp_Present = false;
    private Vector<String> codesNatures;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/TypPce/";
    private static final String CHEMIN_BLOCPIECE_NATPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/NatPce/";
    private static final String CHEMIN_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/";
    private static final String CHEMIN_BALISE_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/Dgp/";
    private static final String CHEMIN_NATURE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/Nature/";
    private static final String CHEMIN_IDLIGNE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In DEP09");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        logger.debug((Object)xpath);
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
        } else if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
            this.piece_TypPce = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_BLOCPIECE_NATPIECE)) {
            this.piece_NatPce = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_IdPce = "";
            this.dgp_Present = false;
            this.anos = new Vector();
            this.codesNatures = new Vector();
        } else if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
            this.piece_nodeId = atts.getValue("ano:node-id");
        } else if (xpath.endsWith(CHEMIN_DGP)) {
            this.dgp_Present = true;
        } else if (xpath.endsWith(CHEMIN_NATURE)) {
            this.codeNature = atts.getValue("V");
            logger.debug((Object)("adding nature " + this.codeNature));
            this.codesNatures.add(this.codeNature);
        } else if (xpath.endsWith(CHEMIN_IDLIGNE)) {
            this.idLigne = atts.getValue("V");
        } else if (xpath.endsWith(CHEMIN_BALISE_DGP)) {
            this.baliseDgp = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(ON_RETURN_ANOMALIES)) {
            if (this.suiviDGP) {
                if (this.dgp_Present) {
                    if (this.isTrue(this.baliseDgp)) {
                        if (this.isPieceEligible(this.piece_TypPce, this.piece_NatPce)) {
                            if (this.isAllNatureUnder012(this.codesNatures)) {
                                this.anos.add(this.createAnomalie(BLOQUANT, "les pi\u00e8ces des chapitres globalis\u00e9s 012 ne peuvent faire l'objet d'un DGP"));
                            }
                        } else {
                            this.anos.add(this.createAnomalie(BLOQUANT, "la pi\u00e8ce n'est pas \u00e9ligible au DGP"));
                        }
                    } else if (this.isPieceEligible(this.piece_TypPce, this.piece_NatPce)) {
                        if (!this.isAllNatureUnder012(this.codesNatures)) {
                            this.anos.add(this.createAnomalie(BLOQUANT, "la balise Dgp doit \u00eatre valoris\u00e9e \u00e0 VRAI (true ou 0) car la pi\u00e8ce est \u00e9ligible au DGP"));
                        } else {
                            this.anos.add(this.createAnomalie(NON_BLOQUANT, "il est incoh\u00e9rent de valoriser le Bloc DGP pour le chapitre globalis\u00e9 012"));
                        }
                    } else if (!this.isAllNatureUnder012(this.codesNatures)) {
                        this.anos.add(this.createAnomalie(BLOQUANT, "le bloc DGP ne doit pas \u00eatre valoris\u00e9 car la pi\u00e8ce n'est pas \u00e9ligible au DGP"));
                    } else {
                        this.anos.add(this.createAnomalie(BLOQUANT, "le bloc DGP ne doit pas \u00eatre valoris\u00e9 car la pi\u00e8ce n'est pas \u00e9ligible au DGP et il s'agit d'un chapitre globalis\u00e9 012"));
                    }
                } else if (!this.isTrue(this.baliseDgp) && this.isPieceEligible(this.piece_TypPce, this.piece_NatPce) && !this.isAllNatureUnder012(this.codesNatures)) {
                    this.anos.add(this.createAnomalie(BLOQUANT, "le bloc DGP devrait \u00eatre valoris\u00e9 car la pi\u00e8ce est \u00e9ligible au DGP"));
                }
            } else if (this.dgp_Present) {
                this.anos.add(this.createAnomalie(BLOQUANT, "il est incoh\u00e9rent de ne pas suivre le DGP (param\u00e9trage X\u00e9m\u00e9lios) et de valoriser un bloc DGP"));
            } else if (this.isTrue(this.baliseDgp)) {
                // empty if block
            }
            return this.anos;
        }
        return null;
    }

    protected Anomalie createAnomalie(String severity, String complMessage) {
        String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
        msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
        msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
        msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
        msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
        msg = msg.concat(complMessage);
        String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
        String anoId = IdGenerator.nextId();
        String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce + ": " + complMessage;
        Hashtable<String, String> xslParams = new Hashtable<String, String>();
        xslParams.put("elementId", "");
        xslParams.put("mandatId", this.piece_IdPce);
        xslParams.put("browser-destination", "internal");
        xslParams.put("anoId", anoId);
        Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), "PES_DepenseAller", "BordereauDepense", this.bord_IdBord, "BlocPiece", libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), severity, path, xslParams);
        ano.addNode(new Node(this.piece_nodeId));
        return ano;
    }

    protected boolean isTrue(String v) {
        if (v == null) {
            return false;
        }
        return "0".equals(v) || "true".equals(v);
    }

    protected boolean isAllNatureUnder012(Vector<String> codes) {
        for (String nat : codes) {
            if (this.isNatureUnder012(nat)) continue;
            return false;
        }
        return true;
    }

    protected boolean isNatureUnder012(String nature) {
        if (nature == null) {
            return false;
        }
        return nature.equals("012") || nature.startsWith("621") || nature.startsWith("631") || nature.startsWith("633") || nature.startsWith("64");
    }

    protected boolean isPieceEligible(String type, String nat) {
        if ("01".equals(type)) {
            return "01".equals(nat) || "02".equals(nat) || "03".equals(nat) || "04".equals(nat) || "05".equals(nat);
        }
        if ("09".equals(type)) {
            return "01".equals(nat) || "02".equals(nat) || "13".equals(nat) || "14".equals(nat);
        }
        return false;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
        if (this.hParams.get("suivdgp") == null) {
            logger.error((Object)"pas de param suividgp !");
        } else {
            this.suiviDGP = (Boolean)this.hParams.get("suivdgp");
        }
    }

    public void setDocumentLocator(Locator locator) {
    }
}

