/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class Streams {
    private static ThreadLocal byteArray = new ThreadLocal(){

        protected Object initialValue() {
            return new byte[4096];
        }
    };
    private static ThreadLocal charArray = new ThreadLocal(){

        protected Object initialValue() {
            return new char[4096];
        }
    };

    public static long copyStream(InputStream in, OutputStream out, long length) throws IOException {
        long total;
        int chunk;
        byte[] buf = (byte[])byteArray.get();
        for (total = 0L; total < length; total += (long)chunk) {
            chunk = (int)Math.min((long)buf.length, length - total);
            if ((chunk = in.read(buf, 0, chunk)) < 0) break;
            out.write(buf, 0, chunk);
        }
        return total;
    }

    public static long copyReader(Reader in, Writer out, long length) throws IOException {
        long total;
        int chunk;
        char[] buf = (char[])charArray.get();
        for (total = 0L; total < length; total += (long)chunk) {
            chunk = (int)Math.min((long)buf.length, length - total);
            if ((chunk = in.read(buf, 0, chunk)) < 0) break;
            out.write(buf, 0, chunk);
        }
        return total;
    }

    public static long copyReader(Reader in, OutputStream out, long length) throws IOException {
        OutputStreamWriter wout = new OutputStreamWriter(out);
        long result = Streams.copyReader(in, wout, length);
        wout.flush();
        return result;
    }

    public static String toString(Reader in) throws IOException {
        StringWriter swriter = new StringWriter();
        Streams.copyReader(in, swriter, Long.MAX_VALUE);
        return swriter.toString();
    }
}

