/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.api;
import com.mysql.embedded.jdbc.MyConnection;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class MySqlEmbeddedDriver
implements Driver {
    public static final boolean SEND_LONG_DATA = "true".equalsIgnoreCase(System.getProperty("mysql-je.send-long-data"));
    protected static int liveConnections = 0;
    public static long databaseHandle = 0L;
    private static Object init_lock = new Object();
    private static boolean is_inited = false;
    public static final String VERSION_NAME = "MySQL Embedded JDBC";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 2;
    public static final String OS_NAME = System.getProperty("os.name");
    protected static boolean windows = OS_NAME.startsWith("Windows");
    protected static boolean unix = !windows;
    protected static boolean macosx = OS_NAME.startsWith("Mac OS X");

    public MySqlEmbeddedDriver() throws SQLException {
        DriverManager.registerDriver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String url, Properties info) throws SQLException {
        MySqlEmbeddedDriver.parseUrlArgs(url, info);
        if (!is_inited) {
            Object object = init_lock;
            synchronized (object) {
                if (!is_inited) {
                    MySqlEmbeddedDriver.loadLibraries(info);
                    databaseHandle = MySqlEmbeddedDriver.init_server(url, info);
                    is_inited = true;
                }
            }
        }
        ++liveConnections;
        MyConnection conn = new MyConnection(info);
        return conn;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:mysql-embedded");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo[] dinfo = new DriverPropertyInfo[5];
        dinfo[0] = new DriverPropertyInfo("user", info.getProperty("user"));
        dinfo[0].description = "Account name for connection. Not needed when connecting with --skip-grant-tables";
        dinfo[1] = new DriverPropertyInfo("password", info.getProperty("password"));
        dinfo[1].description = "Account password for connection. Not needed when connecting with --skip-grant-tables";
        dinfo[2] = new DriverPropertyInfo("libmysqlje", info.getProperty("libmysqlje"));
        dinfo[2].description = "Path to native library libmysqlje. Alternative, the path may be specified with java.library.path";
        dinfo[3] = new DriverPropertyInfo("libmysqld", info.getProperty("libmysqld"));
        dinfo[3].description = "Path to native library libmysqld. Alternative, the path may be specified with java.library.path";
        dinfo[4] = new DriverPropertyInfo("Mysql Property", "...");
        dinfo[4].description = "You can pass most command line properties for MySQL, e.g.--basedir, --datadir. See MySQL manual for details";
        return dinfo;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 2;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void loadLibraries(Properties info) throws UnsatisfiedLinkError {
        Object userPath = info.get("library.path");
        Object userLibs = info.get("library");
        if (userLibs != null) {
            if (userLibs instanceof File) {
                MySqlEmbeddedDriver.loadLibrary((File)userLibs, userPath, "", "");
            } else {
                StringTokenizer tok = new StringTokenizer(userLibs.toString(), File.pathSeparator, false);
                while (tok.hasMoreTokens()) {
                    String fileName = tok.nextToken();
                    MySqlEmbeddedDriver.loadLibrary(fileName, userPath, fileName, "");
                }
            }
        }
        if (windows) {
            MySqlEmbeddedDriver.loadLibrary(info.get("libmysqld"), userPath, "libmysqld.dll", "libmysqld");
            MySqlEmbeddedDriver.loadLibrary(info.get("libmysqlje"), userPath, "libmysqlje.dll", "libmysqlje");
        } else if (macosx) {
            MySqlEmbeddedDriver.loadLibrary(info.get("libmysqlje"), userPath, "libmysqlje.jnilib", "mysqlje");
        } else if (unix) {
            MySqlEmbeddedDriver.loadLibrary(info.get("libmysqlje"), userPath, "libmysqlje.so", "mysqlje");
        }
    }

    protected static boolean loadLibrary(Object userName, Object userPath, String fileName, String libName) {
        File f;
        if (userName != null && (f = userName instanceof File ? (File)userName : new File(userName.toString())).exists()) {
            System.load(f.getAbsolutePath());
            return true;
        }
        if (userPath != null) {
            if (userPath instanceof File) {
                f = new File((File)userPath, fileName);
                if (f.exists()) {
                    System.load(f.getAbsolutePath());
                    return true;
                }
            } else {
                StringTokenizer tok = new StringTokenizer(userPath.toString(), File.pathSeparator, false);
                while (tok.hasMoreTokens()) {
                    File f2 = new File(tok.nextToken(), fileName);
                    if (!f2.exists()) continue;
                    System.load(f2.getAbsolutePath());
                    return true;
                }
            }
        }
        System.loadLibrary(libName);
        return true;
    }

    private static long init_server(String url, Properties info) throws SQLException {
        String[] groups = new String[]{"mysql-je", "embedded", "mysqld", "mysqld-5.0"};
        String[] argv = MySqlEmbeddedDriver.createArgs(info);
        if (argv == null) {
            argv = new String[]{};
        }
        api.mysql_server_init(argv, groups);
        long result = api.mysql_init(0L);
        if (result == 0L) {
            throw new SQLException("could not allocate connection");
        }
        return result;
    }

    private static void parseUrlArgs(String url, Properties info) {
        String database;
        int k0 = url.indexOf(47);
        int k1 = url.indexOf(63, k0 + 1);
        if (k1 < 0) {
            k1 = url.length();
        }
        if (k0 > 0 && (database = url.substring(k0 + 1, k1)).length() > 0) {
            info.put("database", database);
        }
        if (k1 < url.length()) {
            MySqlEmbeddedDriver.parseArgs(url.substring(k1 + 1), info);
        }
    }

    protected static void notifyClosed(MyConnection connection) throws SQLException {
        if (--liveConnections <= 0 && databaseHandle != 0L) {
            api.mysql_close(databaseHandle);
            api.mysql_server_end();
            databaseHandle = 0L;
        }
    }

    private static String[] createArgs(Properties info) {
        ArrayList<String> args = new ArrayList<String>();
        Iterator<Map.Entry<Object, Object>> props = info.entrySet().iterator();
        while (props.hasNext()) {
            Map.Entry<Object, Object> ety = props.next();
            String key = (String)ety.getKey();
            Object value = ety.getValue();
            if (!key.startsWith("--")) continue;
            String arg = key;
            if (value != null) {
                String stringValue;
                if (value instanceof File) {
                    stringValue = ((File)value).getAbsolutePath();
                    stringValue = MySqlEmbeddedDriver.stripSlash(stringValue);
                } else if (key.endsWith("dir") || key.endsWith("file")) {
                    File f = new File(value.toString());
                    stringValue = f.getAbsolutePath();
                    stringValue = MySqlEmbeddedDriver.stripSlash(stringValue);
                } else {
                    stringValue = value.toString();
                }
                if (stringValue.length() > 0) {
                    arg = arg + "=" + stringValue;
                }
            }
            if (arg.startsWith("--defaults-file")) {
                args.add(0, arg);
                continue;
            }
            args.add(arg);
        }
        String[] result = new String[args.size() + 1];
        result[0] = "";
        for (int i = 0; i < args.size(); ++i) {
            result[i + 1] = (String)args.get(i);
        }
        return result;
    }

    private static void parseArgs(String url_args, Properties info) {
        StringTokenizer tok = new StringTokenizer(url_args, "&", false);
        while (tok.hasMoreTokens()) {
            String value;
            String key;
            String arg = tok.nextToken();
            int k1 = arg.indexOf(61);
            if (k1 > 0) {
                key = arg.substring(0, k1);
                value = arg.substring(k1 + 1);
            } else {
                key = arg;
                value = "";
            }
            info.put(key, value);
        }
    }

    private static String stripSlash(String path) {
        int len;
        for (len = path.length(); len > 0 && (path.charAt(len - 1) == '/' || path.charAt(len - 1) == '\\'); --len) {
        }
        if (len == path.length()) {
            return path;
        }
        return path.substring(0, len);
    }

    static {
        try {
            DriverManager.registerDriver(new MySqlEmbeddedDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

