/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.api;
import com.mysql.embedded.api.res;
import com.mysql.embedded.jdbc.MyBlob;
import com.mysql.embedded.jdbc.MyClob;
import com.mysql.embedded.jdbc.MyConnection;
import com.mysql.embedded.jdbc.MyResultSetMetaData;
import com.mysql.embedded.jdbc.MyStatement;
import com.mysql.embedded.util.ByteBufferInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class MyResultSet
implements ResultSet {
    public static final boolean STORE_RESULT = true;
    public static final boolean STREAM_RESULT = false;
    protected MyConnection connection;
    protected MyStatement statement;
    protected boolean stored;
    protected int maxRows;
    protected int currentRowNum;
    protected long resHandle;
    protected long rowHandle;
    protected int[] fieldLengths;
    protected MyResultSetMetaData metaData;
    protected int fieldIndex;

    protected MyResultSet() {
    }

    protected MyResultSet(MyStatement statement, int columnCount, boolean stored, int maxRows) throws SQLException {
        this.setup(statement, statement.connection, columnCount, stored, maxRows, this.resHandle);
        this.resHandle = stored ? api.mysql_store_result(this.connection.connectionHandle) : api.mysql_use_result(this.connection.connectionHandle);
    }

    protected void setup(MyStatement statement, MyConnection connection, int columnCount, boolean stored, int maxRows, long resHandle) throws SQLException {
        this.statement = statement;
        this.connection = connection;
        this.stored = stored;
        this.maxRows = maxRows;
        this.fieldLengths = new int[columnCount];
        this.resHandle = resHandle;
        this.currentRowNum = 0;
        this.metaData = null;
    }

    protected MyResultSet(MyConnection connection, long resHandle) throws SQLException {
        int columnCount = api.mysql_field_count(connection.connectionHandle);
        this.setup(null, connection, columnCount, true, -1, resHandle);
    }

    public boolean next() throws SQLException {
        if (this.resHandle == 0L) {
            return false;
        }
        if (this.maxRows >= 0 && this.currentRowNum >= this.maxRows) {
            this.close();
            return false;
        }
        this.rowHandle = api.mysql_fetch_row(this.resHandle);
        if (this.rowHandle != 0L) {
            api.mysql_fetch_lengths(this.resHandle, this.fieldLengths, this.fieldLengths.length);
            ++this.currentRowNum;
            return true;
        }
        this.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (this.resHandle != 0L) {
                api.mysql_free_result(this.resHandle);
            }
        }
        finally {
            this.resHandle = 0L;
            this.rowHandle = 0L;
            this.currentRowNum = -1;
        }
    }

    public boolean isClosed() {
        return this.resHandle == 0L;
    }

    public boolean wasNull() throws SQLException {
        this.assertColumn(this.rowHandle, this.fieldIndex);
        return res.is_null(this.rowHandle, this.fieldIndex - 1);
    }

    public String getString(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        ByteBuffer buffer = this.getByteBuffer(columnIndex);
        if (buffer == null) {
            return null;
        }
        if (buffer.capacity() == 0) {
            return "";
        }
        return this.connection.decodeString(buffer, buffer.limit());
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getInt(columnIndex) != 0;
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getInt(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getInt(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        this.fieldIndex = columnIndex;
        return res.get_int(this.rowHandle, this.fieldIndex - 1);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        this.fieldIndex = columnIndex;
        return res.get_long(this.rowHandle, this.fieldIndex - 1);
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        this.fieldIndex = columnIndex;
        return res.get_float(this.rowHandle, this.fieldIndex - 1);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        this.fieldIndex = columnIndex;
        return res.get_double(this.rowHandle, this.fieldIndex - 1);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    protected ByteBuffer getByteBuffer(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        this.fieldIndex = columnIndex;
        ByteBuffer buffer = res.get_bytes(this.rowHandle, columnIndex - 1, this.fieldLengths[columnIndex - 1]);
        if (buffer != null) {
            buffer.order(ByteOrder.nativeOrder());
        }
        return buffer;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        ByteBuffer buffer = this.getByteBuffer(columnIndex);
        if (buffer != null) {
            byte[] result = new byte[buffer.limit()];
            buffer.get(result);
            return result;
        }
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, this.connection.utcCalendar);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, this.connection.utcCalendar);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, this.connection.utcCalendar);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        ByteBuffer buffer = this.getByteBuffer(columnIndex);
        if (buffer != null) {
            return new ByteBufferInputStream(buffer);
        }
        return null;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        ByteBuffer buffer = this.getByteBuffer(columnIndex);
        if (buffer != null) {
            return new ByteBufferInputStream(buffer);
        }
        return null;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName), this.connection.utcCalendar);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName), this.connection.utcCalendar);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), this.connection.utcCalendar);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new MyResultSetMetaData(this.resHandle, this.fieldLengths.length, false);
        }
        return this.metaData;
    }

    public Object getObject(int columnIndex) throws SQLException {
        switch (this.getMetaData().getColumnType(columnIndex)) {
            case -5: {
                return this.getBigDecimal(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case -7: {
                boolean b = this.getBoolean(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return b ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                double d = this.getDouble(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 6: {
                float f = this.getFloat(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 4: {
                int i = this.getInt(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Integer(i);
            }
            case -6: 
            case 5: {
                short s = this.getShort(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Short(s);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        throw new SQLException("type " + this.getMetaData().getColumnTypeName(columnIndex) + " not supported");
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        return ((MyResultSetMetaData)this.getMetaData()).findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            return new InputStreamReader(this.getAsciiStream(columnIndex), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("unsupported encoding: " + e.getLocalizedMessage());
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String text = this.getString(columnIndex);
        if (text != null) {
            return new BigDecimal(text);
        }
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentRowNum == 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentRowNum == -1;
    }

    public boolean isFirst() throws SQLException {
        return this.currentRowNum == 1;
    }

    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean first() throws SQLException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getRow() throws SQLException {
        return this.currentRowNum;
    }

    public boolean absolute(int row) throws SQLException {
        if (row - 1 == this.currentRowNum) {
            return this.next();
        }
        if (this.stored) {
            this.currentRowNum = row - 1;
            api.mysql_data_seek(this.resHandle, this.currentRowNum);
            return this.next();
        }
        if (this.currentRowNum < row - 1) {
            while (this.currentRowNum < row - 1) {
                if (this.next()) continue;
                return false;
            }
            return this.next();
        }
        throw new SQLException("can't scroll");
    }

    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.currentRowNum + rows);
    }

    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getType() throws SQLException {
        if (this.stored) {
            return 1004;
        }
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int i) throws SQLException {
        ByteBuffer buffer = this.getByteBuffer(i);
        if (buffer != null) {
            return new MyBlob(buffer);
        }
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        ByteBuffer buffer = this.getByteBuffer(i);
        if (buffer != null) {
            return new MyClob(buffer);
        }
        return null;
    }

    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    protected ShortBuffer getDatePartsShortBuffer(int columnIndex) throws SQLException {
        this.assertColumn(this.rowHandle, columnIndex);
        this.fieldIndex = columnIndex;
        return res.get_date(this.rowHandle, this.fieldIndex - 1, this.connection.sbuffer);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        ShortBuffer parts = this.getDatePartsShortBuffer(columnIndex);
        return MyResultSet.getDate(parts, cal);
    }

    protected static Date getDate(ShortBuffer parts, Calendar cal) {
        if (parts == null) {
            return null;
        }
        cal.set(1, parts.get(0));
        cal.set(2, 0 + Math.max(0, parts.get(1) - 1));
        cal.set(5, Math.max(1, parts.get(2)));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long millis = cal.getTimeInMillis();
        return new Date(millis);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        ShortBuffer parts = this.getDatePartsShortBuffer(columnIndex);
        return MyResultSet.getTime(parts, cal);
    }

    protected static Time getTime(ShortBuffer parts, Calendar cal) {
        if (parts == null) {
            return null;
        }
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, parts.get(3));
        cal.set(12, parts.get(4));
        cal.set(13, parts.get(5));
        cal.set(14, parts.get(6));
        long millis = cal.getTimeInMillis();
        return new Time(millis);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        ShortBuffer parts = this.getDatePartsShortBuffer(columnIndex);
        return MyResultSet.getTimestamp(parts, cal);
    }

    protected static Timestamp getTimestamp(ShortBuffer parts, Calendar cal) {
        if (parts == null) {
            return null;
        }
        cal.set(1, parts.get(0));
        cal.set(2, 0 + Math.max(0, parts.get(1) - 1));
        cal.set(5, Math.max(1, parts.get(2)));
        cal.set(11, parts.get(3));
        cal.set(12, parts.get(4));
        cal.set(13, parts.get(5));
        cal.set(14, parts.get(6));
        long millis = cal.getTimeInMillis();
        return new Timestamp(millis);
    }

    public URL getURL(int columnIndex) throws SQLException {
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw new SQLException("malformed url: " + e.getLocalizedMessage());
        }
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void assertColumn(long rowHandle, int columnIndex) throws SQLException {
        if (rowHandle == 0L) {
            throw new SQLException("illegal result set status");
        }
        if (columnIndex < 1 || columnIndex > this.fieldLengths.length) {
            throw new SQLException("column index out of range");
        }
    }
}

