/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.api;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StructWrapper {
    public static boolean _32bit = true;
    public static boolean _64bit = false;
    protected ByteBuffer b;
    protected long nativeAddress;
    protected int offset;

    public void attach(ByteBuffer b, long nativeAddress, int offset) {
        this.attach(b, nativeAddress, offset, ByteOrder.nativeOrder());
    }

    public void attach(ByteBuffer b, long nativeAddress, int offset, ByteOrder byteOrder) {
        this.b = b;
        this.nativeAddress = nativeAddress;
        this.offset = offset;
        this.b.order(byteOrder);
    }

    public boolean getBoolean(int offset) {
        return this.getByte(offset) != 0;
    }

    public byte getByte(int offset) {
        return this.b.get(this.offset + offset);
    }

    public short getUnsignedByte(int offset) {
        return (short)(0xFF & this.b.get(this.offset + offset));
    }

    public short getShort(int offset) {
        return this.b.getShort(this.offset + offset);
    }

    public int getUnsignedShort(int offset) {
        return 0xFFFF & this.b.getShort(this.offset + offset);
    }

    public int getInt(int offset) {
        return this.b.getInt(this.offset + offset);
    }

    public long getUnsignedInt(int offset) {
        return 0xFFFFFFFF & this.b.getInt(this.offset + offset);
    }

    public long getLong(int offset) {
        return this.b.getLong(this.offset + offset);
    }

    public float getFloat(int offset) {
        return this.b.getFloat(this.offset + offset);
    }

    public double getDouble(int offset) {
        return this.b.getDouble(this.offset + offset);
    }

    public long getPointer(int offset) {
        return _64bit ? this.getLong(offset) : (long)this.getInt(offset);
    }

    public void setBoolean(int offset, boolean value) {
        this.setByte(offset, value ? (byte)1 : 0);
    }

    public void setByte(int offset, byte value) {
        this.b.put(this.offset + offset, value);
    }

    public void setShort(int offset, short value) {
        this.b.putShort(this.offset + offset, value);
    }

    public void setInt(int offset, int value) {
        this.b.putInt(this.offset + offset, value);
    }

    public void setLong(int offset, long value) {
        this.b.putLong(this.offset + offset, value);
    }

    public void setFloat(int offset, float value) {
        this.b.putFloat(this.offset + offset, value);
    }

    public void setDouble(int offset, double value) {
        this.b.putDouble(this.offset + offset, value);
    }

    public void setPointer(int offset, long value) {
        if (_64bit) {
            this.setLong(offset, value);
        } else {
            this.setInt(offset, (int)value);
        }
    }

    public static boolean getBoolean(ByteBuffer b, int offset) {
        return b.get(offset) != 0;
    }

    public static short getUnsignedByte(ByteBuffer b, int offset) {
        return (short)(0xFF & b.get(offset));
    }

    public static int getUnsignedShort(ByteBuffer b, int offset) {
        return 0xFFFF & b.getShort(offset);
    }

    public static long getUnsignedInt(ByteBuffer b, int offset) {
        return 0xFFFFFFFF & b.getInt(offset);
    }

    public static void setBoolean(ByteBuffer b, int offset, boolean value) {
        b.put(offset, value ? (byte)1 : 0);
    }
}

