/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization.MysqlDrsParser;
import fr.gouv.finances.dgfip.utils.Base64;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataResultSetWrapperModel
implements XmlMarshallable {
    private static final transient String DEFAULT_XML_ENCODING = "UTF-8";
    public static final Logger logger = Logger.getLogger(DataResultSetWrapperModel.class);
    public static final QName QN = new QName("http://xemelios.org/namespaces/data/mysql#drsw", "DataResultSetWrapper", "d");
    public static final QName ATTR_ClassName = new QName("http://xemelios.org/namespaces/data/mysql#drsw", "className", "d");
    private String className;
    private StringBuilder stringBuffer = new StringBuilder();
    private byte[] byteBuffer;

    public DataResultSetWrapperModel(QName tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
        this.stringBuffer.append(cData);
    }

    public void addChild(XmlMarshallable child, QName tag) throws SAXException {
        throw new SAXException("unexpected child: " + tag);
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.className = attributes.getValue(ATTR_ClassName.getNamespaceURI(), ATTR_ClassName.getLocalPart());
        return this;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(QN);
        if (this.className == null) {
            throw new RuntimeException("className must not be null !!!");
        }
        output.addAttribute(ATTR_ClassName, this.className);
        if (this.byteBuffer != null) {
            output.addCharacterData(Base64.encodeBytes((byte[])this.byteBuffer, (boolean)true));
        } else {
            output.addCharacterData(this.stringBuffer.toString());
        }
        output.endTag(QN);
    }

    public void validate() throws InvalidXmlDefinition {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QName getQName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DataResultSetWrapperModel clone() {
        return this;
    }

    public DataResultSet getDataResultSet() {
        if (MySqlDataResultSet.class.getName().equals(this.className)) {
            try {
                MysqlDrsParser parser = new MysqlDrsParser();
                if (this.byteBuffer == null) {
                    this.byteBuffer = Base64.decode((String)this.stringBuffer.toString());
                }
                parser.parse(new ByteArrayInputStream(this.byteBuffer));
                XmlMarshallable obj = parser.getMarshallable();
                MySqlDataResultSet mdrs = (MySqlDataResultSet)obj;
                mdrs.finishInit(Loader.getDocumentsInfos(null));
                return mdrs;
            }
            catch (Exception ex) {
                logger.error((Object)"getDataResultSet()", (Throwable)ex);
                return null;
            }
        }
        throw new UnsupportedOperationException(this.className.concat(" is not yet supported as a serializable DataResultSet"));
    }

    public void setDataResultSet(DataResultSet drs) {
        this.className = drs.getClass().getName();
        if (!(drs instanceof MySqlDataResultSet)) {
            throw new UnsupportedOperationException(drs.getClass().getName() + ": not yet supported as a serializable DataResultSet");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Charset cs = Charset.forName(DEFAULT_XML_ENCODING);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, cs);
            XmlOutputter out = new XmlOutputter(osw, cs.name());
            ((MySqlDataResultSet)drs).marshall(out);
            osw.flush();
            this.byteBuffer = baos.toByteArray();
            this.stringBuffer = new StringBuilder();
        }
        catch (Exception ex) {
            logger.error((Object)"setDataResultSet(DataResultSet)", (Throwable)ex);
        }
    }
}

