<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
 * Copyright
 *   2009 axYus - www.axyus.com
 *   2009 c.Marchand - christophe.marchand@axyus.com
 *
 * This file is part of XEMELIOS.
 *
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:n="http://projets.admisource.gouv.fr/xemelios/namespaces#edmn" version="2.0">

 <xsl:output method="xml" indent="yes" exclude-result-prefixes="xsl"/>

 <xsl:param name="liasses"/>

 <xsl:template match="/n:Edmn">
     <xsl:call-template name="writeElement"><xsl:with-param name="el" select="."/></xsl:call-template>
 </xsl:template>


 <xsl:template name="writeElement">
  <xsl:param name="el"/>
  <xsl:element name="{name($el)}" namespace="{namespace-uri($el)}">
   <xsl:for-each select="$el/@*">
    <xsl:attribute name="{name(.)}" namespace="{namespace-uri(.)}">
     <xsl:value-of select="."/>
    </xsl:attribute>
   </xsl:for-each>
   <xsl:for-each select="$el/*">
    <xsl:if test="not(local-name(.) = 'NumLiasseNationale')">
        <xsl:call-template name="writeElement"><xsl:with-param name="el" select="."/></xsl:call-template>
    </xsl:if>
    <xsl:if test="local-name(.) = 'CodeCorrection'">
        <xsl:comment>count(//n:Liasse) = <xsl:value-of select="count($liasses//n:Liasse)"/></xsl:comment>
     <xsl:if test="count($liasses//n:Liasse) gt 0">
      <xsl:element name="NumLiasseNationale" namespace="http://projets.admisource.gouv.fr/xemelios/namespaces#edmn">
       <xsl:attribute name="allLiasse" namespace="http://projets.admisource.gouv.fr/xemelios/namespaces#edmn"><xsl:value-of select="$liasses//n:Liasse/@national" separator=" "/></xsl:attribute>
       <!--xsl:for-each select="tokenize($liasses,' +')">
        <xsl:element name="Liasse" namespace="http://projets.admisource.gouv.fr/xemelios/namespaces#edmn">
         <xsl:attribute name="V"><xsl:value-of select="."/></xsl:attribute>
        </xsl:element>
        </xsl:for-each-->
       <xsl:for-each select="$liasses//n:Liasse"><xsl:copy-of select="."/></xsl:for-each>
      </xsl:element>
     </xsl:if>
    </xsl:if></xsl:for-each></xsl:element>
 </xsl:template>

</xsl:stylesheet>
