/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.edmn.patchers;

import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.importers.AbstractImportPatcherImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NumLiassePatcher
extends AbstractImportPatcherImpl {
    private static final Logger logger = Logger.getLogger(NumLiassePatcher.class);
    private static final String TABLE_INDEX = "INDEX_PATCH";
    private static final String SCRIPT_INDEX = "CREATE TABLE IF NOT EXISTS INDEX_PATCH (\nIND_ANNEE_GEST VARCHAR(2) not null,\nIND_TRI_GEST VARCHAR(1) not null,\nIND_COMPTABLE VARCHAR(6) not null,\nIND_IMPUTATION VARCHAR(1) not null,\nIND_MINISTERE VARCHAR(2) not null,\nIND_COMPTESPE VARCHAR(5) not null,\nIND_LOCALE VARCHAR(4) not null,\nIND_ANNEE_TRSP VARCHAR(2) not null,\nIND_TRI_TRSP VARCHAR(1) not null,\nIND_SECTION_BUDG VARCHAR(2),\nIND_CPTESPENAT VARCHAR(5) not null,\nIND_NATIONALE VARCHAR(6),\nINDEX IX_INDEX (IND_ANNEE_GEST,IND_TRI_GEST,IND_COMPTABLE,IND_IMPUTATION,IND_MINISTERE,IND_LOCALE)\n)";
    private static final transient String REQUEST = "SELECT edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID FROM EDMN_ETATEDMN_INDEX_EDMN edmn LEFT OUTER JOIN EDMN_ETATEDMN_IX_EDMN_LIASSES liasse ON edmn.COLLECTIVITE=liasse.COLLECTIVITE and edmn.BUDGET=liasse.BUDGET and edmn.DOC_ID=liasse.DOC_ID GROUP BY edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID HAVING count(liasse.DOC_ID)=0";
    private static final transient String REQUEST_COUNT = "SELECT count(*) from ( SELECT edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID FROM EDMN_ETATEDMN_INDEX_EDMN edmn LEFT OUTER JOIN EDMN_ETATEDMN_IX_EDMN_LIASSES liasse ON edmn.COLLECTIVITE=liasse.COLLECTIVITE and edmn.BUDGET=liasse.BUDGET and edmn.DOC_ID=liasse.DOC_ID GROUP BY edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID HAVING count(liasse.DOC_ID)=0 ) as toto";
    protected DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    protected TransformerFactory transformerFactory;

    public NumLiassePatcher() {
        this.domFactory.setNamespaceAware(true);
        this.transformerFactory = TransformerFactoryImpl.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo run() {
        this.getImportServiceProvider().startLongWait();
        File indexFile = (File)this.getParameter("index.file");
        Connection conPatch = null;
        Connection con2 = null;
        Connection con3 = null;
        int rowPatched = 0;
        try {
            conPatch = PoolManager.getInstance().getConnection();
            con2 = PoolManager.getInstance().getConnection();
            con3 = PoolManager.getInstance().getConnection();
            Statement st = conPatch.createStatement();
            st.execute(SCRIPT_INDEX);
            st.execute("TRUNCATE TABLE INDEX_PATCH");
            PreparedStatement ps = conPatch.prepareStatement("INSERT INTO INDEX_PATCH (IND_ANNEE_GEST,IND_TRI_GEST,IND_COMPTABLE,IND_IMPUTATION,IND_MINISTERE,IND_COMPTESPE,IND_LOCALE,IND_ANNEE_TRSP,IND_TRI_TRSP,IND_SECTION_BUDG,IND_CPTESPENAT,IND_NATIONALE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
            BufferedReader br = new BufferedReader(new FileReader(indexFile));
            String line = br.readLine();
            while (line != null && line.length() > 0) {
                String[] els = line.split(";");
                for (int i = 0; i < 12; ++i) {
                    ps.setString(i + 1, els[i]);
                }
                ps.executeUpdate();
                line = br.readLine();
            }
            ResultSet rs = con2.createStatement().executeQuery(REQUEST_COUNT);
            rs.next();
            int rows = rs.getInt(1);
            this.getImportServiceProvider().endLongWait();
            br.close();
            rs = con2.createStatement().executeQuery(REQUEST);
            int rowFetched = 0;
            while (rs.next()) {
                String docId;
                String budget;
                int progress = (int)((double)(rowFetched + 1) * 100.0 / (double)rows);
                this.getImportServiceProvider().pushCurrentProgress(progress);
                String collectivite = rs.getString(1);
                if (!this.patchDocument(collectivite, budget = rs.getString(2), docId = rs.getString(3), conPatch, con3)) continue;
                ++rowPatched;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"run()", (Throwable)ex);
        }
        finally {
            if (conPatch != null) {
                PoolManager.getInstance().releaseConnection(conPatch);
            }
            if (con2 != null) {
                PoolManager.getInstance().releaseConnection(con2);
            }
            if (con3 != null) {
                PoolManager.getInstance().releaseConnection(con3);
            }
            this.getImportServiceProvider().endLongWait();
        }
        FileInfo ret = new FileInfo();
        ret.setMessage(rowPatched + " mandats corrig\u00e9s pour les liasses nationales\n");
        return ret;
    }

    private boolean patchDocument(String collectivite, String budget, String docId, Connection conPatch, Connection con2) throws Exception {
        boolean ret = false;
        PreparedStatement psLiassesLocales = con2.prepareStatement("SELECT edmn.COMPTABLE, edmn.IMPUTATION, edmn.MINISTERE, edmn.ANNEE_BUDG, edmn.TRIMESTRE, edmn.NUM_LIASSE_DEB, edmn.NUM_LIASSE_FIN FROM EDMN_ETATEDMN_INDEX_EDMN edmn where edmn.COLLECTIVITE=? AND edmn.BUDGET=? AND edmn.DOC_ID=?");
        psLiassesLocales.setString(1, collectivite);
        psLiassesLocales.setString(2, budget);
        psLiassesLocales.setString(3, docId);
        ResultSet rsLiasses = psLiassesLocales.executeQuery();
        if (rsLiasses.next()) {
            String comptable = rsLiasses.getString(1);
            String imputation = rsLiasses.getString(2);
            String ministere = rsLiasses.getString(3);
            String annee = rsLiasses.getString(4);
            String trimestre = rsLiasses.getString(5);
            String numLiasseDeb = rsLiasses.getString(6);
            String numLiasseFin = rsLiasses.getString(7);
            StringBuffer numLiasses = new StringBuffer();
            int first = 0;
            int last = 0;
            try {
                first = Integer.parseInt(numLiasseDeb);
            }
            catch (NumberFormatException nfEx) {
                // empty catch block
            }
            try {
                last = Integer.parseInt(numLiasseFin);
            }
            catch (NumberFormatException nfEx) {
                // empty catch block
            }
            numLiasses.append("(");
            for (int i = first; i < last; ++i) {
                numLiasses.append("'").append(NumLiassePatcher.fmtNumLiasse(i)).append("',");
            }
            numLiasses.append("'").append(NumLiassePatcher.fmtNumLiasse(last)).append("')");
            String sql = "SELECT IND_ANNEE_GEST, IND_TRI_GEST, IND_COMPTABLE, IND_IMPUTATION, IND_MINISTERE, IND_COMPTESPE, IND_LOCALE, IND_ANNEE_TRSP, IND_TRI_TRSP, IND_SECTION_BUDG, IND_CPTESPENAT, IND_NATIONALE FROM INDEX_PATCH WHERE IND_ANNEE_GEST=? AND IND_TRI_GEST=? AND IND_COMPTABLE=? AND IND_IMPUTATION=? AND IND_MINISTERE=? AND IND_LOCALE IN " + numLiasses.toString() + " ORDER BY IND_LOCALE";
            PreparedStatement ps = conPatch.prepareStatement(sql);
            ps.setString(1, annee.substring(2));
            ps.setString(2, trimestre);
            ps.setString(3, comptable);
            ps.setString(4, imputation);
            ps.setString(5, ministere);
            ResultSet rs2 = ps.executeQuery();
            ArrayList<Liasse> liasses = new ArrayList<Liasse>();
            while (rs2.next()) {
                liasses.add(new Liasse(rs2));
            }
            rs2.close();
            ps.close();
            if (liasses.size() > 0) {
                ps = con2.prepareStatement("INSERT INTO EDMN_ETATEDMN_IX_EDMN_LIASSES (COLLECTIVITE,BUDGET,DOC_ID,NUM_LIASSE,ANNEE_GESTION) VALUES(?,?,?,?,?)");
                ps.setString(1, collectivite);
                ps.setString(2, budget);
                ps.setString(3, docId);
                ps.setString(5, annee);
                for (Liasse l : liasses) {
                    ps.setString(4, l.getNumNat());
                    ps.executeUpdate();
                }
                ps.close();
                ps = con2.prepareStatement("SELECT DOC, ENCODING FROM EDMN_ETATEDMN_DOCUMENTS WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
                ps.setString(1, collectivite);
                ps.setString(2, budget);
                ps.setString(3, docId);
                rs2 = ps.executeQuery();
                if (rs2.next()) {
                    String encoding = rs2.getString(2);
                    byte[] buff = new byte[512];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = rs2.getAsciiStream(1);
                    int length = is.read(buff);
                    while (length > 0) {
                        baos.write(buff, 0, length);
                        length = is.read(buff);
                    }
                    DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                    byte[] byteArray = baos.toByteArray();
                    ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                    Document doc = builder.parse(bis);
                    Transformer trans = this.transformerFactory.newTransformer(new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("fr/gouv/finances/dgfip/xemelios/edmn/patchers/numLiassePatcher.xsl")));
                    ByteArrayOutputStream newDoc = new ByteArrayOutputStream();
                    DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                    Document dom = domBuilder.newDocument();
                    Element elLiasses = dom.createElementNS("http://projets.admisource.gouv.fr/xemelios/namespaces#edmn", "Liasses");
                    dom.appendChild(elLiasses);
                    for (Liasse l : liasses) {
                        elLiasses.appendChild(l.getDomNode(dom));
                    }
                    trans.setParameter("liasses", new DOMSource(dom));
                    trans.setOutputProperty("encoding", encoding);
                    trans.transform(new DOMSource(doc), new StreamResult(newDoc));
                    ps.close();
                    ps = con2.prepareStatement("UPDATE EDMN_ETATEDMN_DOCUMENTS SET DOC=? WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
                    ps.setString(2, collectivite);
                    ps.setString(3, budget);
                    ps.setString(4, docId);
                    byte[] newDocArray = newDoc.toByteArray();
                    ByteArrayInputStream isNewDoc = new ByteArrayInputStream(newDocArray);
                    ps.setBinaryStream(1, (InputStream)isNewDoc, newDocArray.length);
                    if (ps.executeUpdate() > 0) {
                        ret = true;
                    }
                    ps.close();
                }
                rs2.close();
            }
        }
        rsLiasses.close();
        psLiassesLocales.close();
        return ret;
    }

    protected static String fmtNumLiasse(int i) {
        String v = Integer.toString(i);
        while (v.length() < 4) {
            v = "0".concat(v);
        }
        return v;
    }

    private class Liasse {
        private String anneeGestion;
        private String triGestion;
        private String comptable;
        private String imputation;
        private String ministere;
        private String compteSpeTresor;
        private String numLocal;
        private String anneeTrsp;
        private String triTrsp;
        private String sectionBudg;
        private String cpteSpeNat;
        private String numNat;

        public Liasse(ResultSet rs) throws SQLException {
            int i = 1;
            this.anneeGestion = rs.getString(i++);
            this.triGestion = rs.getString(i++);
            this.comptable = rs.getString(i++);
            this.imputation = rs.getString(i++);
            this.ministere = rs.getString(i++);
            this.compteSpeTresor = rs.getString(i++);
            this.numLocal = rs.getString(i++);
            this.anneeTrsp = rs.getString(i++);
            this.triTrsp = rs.getString(i++);
            this.sectionBudg = rs.getString(i++);
            this.cpteSpeNat = rs.getString(i++);
            this.numNat = rs.getString(i++);
        }

        public String getAnneeGestion() {
            return this.anneeGestion;
        }

        public String getAnneeTrsp() {
            return this.anneeTrsp;
        }

        public String getComptable() {
            return this.comptable;
        }

        public String getCompteSpeTresor() {
            return this.compteSpeTresor;
        }

        public String getCpteSpeNat() {
            return this.cpteSpeNat;
        }

        public String getImputation() {
            return this.imputation;
        }

        public String getMinistere() {
            return this.ministere;
        }

        public String getNumLocal() {
            return this.numLocal;
        }

        public String getNumNat() {
            return this.numNat;
        }

        public String getSectionBudg() {
            return this.sectionBudg;
        }

        public String getTriGestion() {
            return this.triGestion;
        }

        public String getTriTrsp() {
            return this.triTrsp;
        }

        public Element getDomNode(Document dom) {
            Element el = dom.createElementNS("http://projets.admisource.gouv.fr/xemelios/namespaces#edmn", "Liasse");
            el.setAttribute("anneeGest", this.anneeGestion);
            el.setAttribute("triGest", this.triGestion);
            el.setAttribute("cpteSpeTres", this.compteSpeTresor);
            el.setAttribute("local", this.numLocal);
            el.setAttribute("anneeTrsp", this.anneeTrsp);
            el.setAttribute("triTrsp", this.triTrsp);
            el.setAttribute("sectionBudg", this.sectionBudg);
            el.setAttribute("cpteSpeNat", this.cpteSpeNat);
            el.setAttribute("national", this.numNat);
            String codeBarre = this.anneeGestion + "." + this.triGestion + "." + this.comptable + "." + this.imputation + this.ministere + "." + this.compteSpeTresor + "." + this.numLocal;
            String etq = this.sectionBudg + "." + this.anneeTrsp + "." + this.triTrsp + "." + this.cpteSpeNat + "." + this.numNat;
            el.setAttribute("codeBarre", codeBarre);
            el.setAttribute("etq", etq);
            return el;
        }
    }
}

