/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.edmn.patchers;

import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TTable;
import fr.gouv.finances.dgfip.xemelios.importers.AbstractImportPatcherImpl;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RepositoryDropper
extends AbstractImportPatcherImpl {
    private static final Logger logger = Logger.getLogger(RepositoryDropper.class);

    public FileInfo run() {
        try {
            DataImpl di = DataLayerManager.getImplementation();
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById("edmn");
            User user = new User();
            TDocument doc = di.getPersistenceConfig(dm, (XemeliosUser)user).getLayer(di.getLayerName()).getDocument("edmn");
            for (TEtat etat : doc.getEtats()) {
                if (!etat.getId().equals("etatEdmn")) {
                    logger.debug((Object)("dropping tables for " + etat.getId()));
                    this.recreate(etat.getDocumentTable());
                    for (TTable table : etat.getIndexTables()) {
                        this.recreate(table);
                    }
                    continue;
                }
                logger.debug((Object)("skipping " + etat.getId()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new FileInfo();
    }

    private void recreate(TTable table) throws SQLException {
        Connection con = null;
        try {
            con = PoolManager.getInstance().getConnection();
            con.createStatement().execute("DROP TABLE " + table.getBaseName());
            con.createStatement().execute(table.getScript());
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        finally {
            if (con != null) {
                PoolManager.getInstance().releaseConnection(con);
            }
            con = null;
        }
    }

    private class User
    implements XemeliosUser {
        private User() {
        }

        public String getId() {
            return "importer";
        }

        public String getDisplayName() {
            return this.getId();
        }

        public boolean hasRole(String role) {
            return true;
        }

        public boolean hasDocument(String document) {
            return true;
        }

        public boolean hasCollectivite(String collectivite, DocumentModel dm) {
            return true;
        }
    }
}

