/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.edmn.patchers;

import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.importers.AbstractImportPatcherImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class NumLiassePatcher
extends AbstractImportPatcherImpl {
    private static final Logger logger = Logger.getLogger(NumLiassePatcher.class);
    private static final transient String SCRIPT = "CREATE TEMPORARY TABLE IF NOT EXISTS INDEX_PATCH (\nANNEE VARCHAR(2),\nTRIMESTRE VARCHAR(1),\nCOMPTABLE VARCHAR(6),\nMINISTERE VARCHAR(3),\nLOCAL VARCHAR(4),\nNATIONAL VARCHAR(6),\nINDEX IX_PATCH(ANNEE,TRIMESTRE,COMPTABLE,MINISTERE,LOCAL)\n)";
    private static final transient String REQUEST = "SELECT edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID FROM EDMN_ETATEDMN_INDEX_EDMN edmn LEFT OUTER JOIN EDMN_ETATEDMN_IX_EDMN_LIASSES liasse ON edmn.COLLECTIVITE=liasse.COLLECTIVITE and edmn.BUDGET=liasse.BUDGET and edmn.DOC_ID=liasse.DOC_ID GROUP BY edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID HAVING count(liasse.DOC_ID)=0";
    private static final transient String REQUEST_COUNT = "SELECT count(*) from ( SELECT edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID FROM EDMN_ETATEDMN_INDEX_EDMN edmn LEFT OUTER JOIN EDMN_ETATEDMN_IX_EDMN_LIASSES liasse ON edmn.COLLECTIVITE=liasse.COLLECTIVITE and edmn.BUDGET=liasse.BUDGET and edmn.DOC_ID=liasse.DOC_ID GROUP BY edmn.COLLECTIVITE, edmn.BUDGET, edmn.DOC_ID HAVING count(liasse.DOC_ID)=0 ) as toto";
    protected DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    protected TransformerFactory transformerFactory = TransformerFactoryImpl.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo run() {
        this.getImportServiceProvider().startLongWait();
        File indexFile = (File)this.getParameter("index.file");
        Connection conPatch = null;
        Connection con2 = null;
        Connection con3 = null;
        int rowPatched = 0;
        try {
            conPatch = PoolManager.getInstance().getConnection();
            con2 = PoolManager.getInstance().getConnection();
            con3 = PoolManager.getInstance().getConnection();
            Statement st = conPatch.createStatement();
            st.execute(SCRIPT);
            st.execute("TRUNCATE TABLE INDEX_PATCH");
            PreparedStatement ps = conPatch.prepareStatement("INSERT INTO INDEX_PATCH(ANNEE,TRIMESTRE,COMPTABLE,MINISTERE,LOCAL,NATIONAL) VALUES (?,?,?,?,?,?)");
            BufferedReader br = new BufferedReader(new FileReader(indexFile));
            String line = br.readLine();
            while (line != null && line.length() > 0) {
                String[] els = line.split(";");
                for (int i = 0; i < 6; ++i) {
                    ps.setString(i + 1, els[i]);
                }
                ps.executeUpdate();
                line = br.readLine();
            }
            ResultSet rs = con2.createStatement().executeQuery(REQUEST_COUNT);
            rs.next();
            int rows = rs.getInt(1);
            this.getImportServiceProvider().endLongWait();
            br.close();
            rs = con2.createStatement().executeQuery(REQUEST);
            int rowFetched = 0;
            while (rs.next()) {
                String docId;
                String budget;
                int progress = (int)((double)(rowFetched + 1) * 100.0 / (double)rows);
                this.getImportServiceProvider().pushCurrentProgress(progress);
                String collectivite = rs.getString(1);
                if (!this.patchDocument(collectivite, budget = rs.getString(2), docId = rs.getString(3), conPatch, con3)) continue;
                ++rowPatched;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"run()", (Throwable)ex);
        }
        finally {
            if (conPatch != null) {
                try {
                    conPatch.createStatement().executeUpdate("DROP TABLE INDEX_PATCH");
                }
                catch (Exception ex) {}
                PoolManager.getInstance().releaseConnection(conPatch);
            }
            if (con2 != null) {
                PoolManager.getInstance().releaseConnection(con2);
            }
            if (con3 != null) {
                PoolManager.getInstance().releaseConnection(con3);
            }
            this.getImportServiceProvider().endLongWait();
        }
        FileInfo ret = new FileInfo();
        ret.setMessage(rowPatched + " mandats corrig\u00e9s pour les liasses nationales\n");
        return ret;
    }

    private boolean patchDocument(String collectivite, String budget, String docId, Connection conPatch, Connection con2) throws Exception {
        boolean ret = false;
        PreparedStatement psLiassesLocales = con2.prepareStatement("SELECT edmn.COMPTABLE, edmn.MINISTERE, edmn.ANNEE_BUDG, edmn.TRIMESTRE, edmn.NUM_LIASSE_DEB, edmn.NUM_LIASSE_FIN FROM EDMN_ETATEDMN_INDEX_EDMN edmn where edmn.COLLECTIVITE=? AND edmn.BUDGET=? AND edmn.DOC_ID=?");
        psLiassesLocales.setString(1, collectivite);
        psLiassesLocales.setString(2, budget);
        psLiassesLocales.setString(3, docId);
        ResultSet rsLiasses = psLiassesLocales.executeQuery();
        if (rsLiasses.next()) {
            String comptable = rsLiasses.getString(1);
            String ministere = rsLiasses.getString(2);
            String annee = rsLiasses.getString(3);
            String trimestre = rsLiasses.getString(4);
            String numLiasseDeb = rsLiasses.getString(5);
            String numLiasseFin = rsLiasses.getString(6);
            PreparedStatement ps = conPatch.prepareStatement("SELECT NATIONAL FROM INDEX_PATCH WHERE ANNEE=? AND TRIMESTRE=? AND COMPTABLE=? AND MINISTERE=? AND LOCAL>=? AND LOCAL<=?");
            ps.setString(1, annee.substring(2));
            ps.setString(2, trimestre);
            ps.setString(3, comptable);
            ps.setString(4, ministere);
            ps.setString(5, numLiasseDeb);
            ps.setString(6, numLiasseFin);
            ResultSet rs2 = ps.executeQuery();
            StringBuilder numLiassesNat = new StringBuilder();
            ArrayList<String> liasses = new ArrayList<String>();
            while (rs2.next()) {
                numLiassesNat.append(rs2.getString(1)).append(" ");
                liasses.add(rs2.getString(1));
            }
            rs2.close();
            ps.close();
            if (liasses.size() > 0) {
                logger.debug((Object)("patching [" + collectivite + "," + budget + "," + docId + "]"));
                numLiassesNat.deleteCharAt(numLiassesNat.length() - 1);
                ps = con2.prepareStatement("INSERT INTO EDMN_ETATEDMN_IX_EDMN_LIASSES (COLLECTIVITE,BUDGET,DOC_ID,NUM_LIASSE) VALUES(?,?,?,?)");
                ps.setString(1, collectivite);
                ps.setString(2, budget);
                ps.setString(3, docId);
                for (String l : liasses) {
                    ps.setString(4, l);
                    ps.executeUpdate();
                }
                ps.close();
                ps = con2.prepareStatement("SELECT DOC, ENCODING FROM EDMN_ETATEDMN_DOCUMENTS WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
                ps.setString(1, collectivite);
                ps.setString(2, budget);
                ps.setString(3, docId);
                rs2 = ps.executeQuery();
                if (rs2.next()) {
                    String encoding = rs2.getString(2);
                    byte[] buff = new byte[512];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = rs2.getAsciiStream(1);
                    int length = is.read(buff);
                    while (length > 0) {
                        baos.write(buff, 0, length);
                        length = is.read(buff);
                    }
                    DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                    byte[] byteArray = baos.toByteArray();
                    ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                    Document doc = builder.parse(bis);
                    Transformer trans = this.transformerFactory.newTransformer(new StreamSource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("fr/gouv/finances/dgfip/xemelios/edmn/patchers/numLiassePatcher.xsl")));
                    ByteArrayOutputStream newDoc = new ByteArrayOutputStream();
                    trans.setParameter("liasses", numLiassesNat.toString());
                    trans.setOutputProperty("encoding", encoding);
                    trans.transform(new DOMSource(doc), new StreamResult(newDoc));
                    ps.close();
                    ps = con2.prepareStatement("UPDATE EDMN_ETATEDMN_DOCUMENTS SET DOC=? WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=?");
                    ps.setString(2, collectivite);
                    ps.setString(3, budget);
                    ps.setString(4, docId);
                    byte[] newDocArray = newDoc.toByteArray();
                    ByteArrayInputStream isNewDoc = new ByteArrayInputStream(newDocArray);
                    ps.setBinaryStream(1, (InputStream)isNewDoc, newDocArray.length);
                    if (ps.executeUpdate() > 0) {
                        ret = true;
                    }
                    ps.close();
                }
                rs2.close();
            }
        }
        rsLiasses.close();
        psLiassesLocales.close();
        return ret;
    }
}

