/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);
    private static File tempDir = null;

    public static String readTextFile(File f, String fileEncoding) throws IOException {
        StringBuffer sb = new StringBuffer();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(f), fileEncoding);
        char[] buf = new char[255];
        int read = isr.read(buf);
        while (read > 0) {
            sb.append(buf, 0, read);
            read = isr.read(buf);
        }
        isr.close();
        return sb.toString();
    }

    public static String getFileEncoding(File f) throws IOException {
        String ret = null;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        byte[] bb = new byte[255];
        bis.read(bb);
        String buff = new String(bb);
        buff = buff.substring(buff.indexOf("<?"));
        String header = buff = buff.substring(0, buff.indexOf("?>") + 2);
        int encodingPos = header.indexOf("encoding=");
        if (encodingPos >= 0) {
            String s = header.substring(encodingPos + 9);
            ret = s.startsWith("\"") ? s.substring(1, s.indexOf(34, 1)) : ((s = s.substring(0, s.length() - 2).trim()).indexOf(32) > 0 ? s.substring(0, s.indexOf(32)) : s);
        } else {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
            ret = isr.getEncoding();
            isr.close();
        }
        bis.close();
        return ret;
    }

    public static void dropRecursiveDirectory(File dir) throws Exception {
        File[] files;
        if (!dir.exists()) {
            throw new Exception(dir.getAbsolutePath() + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new Exception(dir.getAbsolutePath() + " is not a directory");
        }
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                FileUtils.dropRecursiveDirectory(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    public static boolean isXmlFile(File input, String encoding) {
        boolean ret = false;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), encoding));
            String line = br.readLine();
            int i = 0;
            while (line != null) {
                if (line.trim().length() > 0) {
                    return ++i == 1 && line.trim().matches("[<][?]xml version[=].* encoding[=].*[?][>].*");
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me dans isXmlFile() :\n", (Throwable)e);
        }
        return ret;
    }

    public static File getTempDir() {
        return tempDir;
    }

    static {
        tempDir = new File(new File(System.getProperty("java.io.tmpdir")), "XEMELIOS");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }
}

