/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.plugins;

import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PluginModel;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchPlugin {
    private Hashtable<String, String> params;
    private XemeliosUser user;
    private ElementModel elementModel;
    private Pair collectivite;
    private Pair budget;
    private Pair nomenclatureReference;
    private PluginModel model;
    private ListeResultatModel lrm;

    public SearchPlugin(XemeliosUser user) {
        this.user = user;
    }

    public void setElementModel(ElementModel em) {
        this.elementModel = em;
    }

    public ElementModel getElementModel() {
        return this.elementModel;
    }

    public void setCollectivite(Pair coll) {
        this.collectivite = coll;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setBudget(Pair budg) {
        this.budget = budg;
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void setNomenclatureReference(Pair nomencl) {
        this.nomenclatureReference = nomencl;
    }

    public Pair getNomenclatureReference() {
        return this.nomenclatureReference;
    }

    public EtatModel getEtatModel() {
        return this.elementModel.getParent();
    }

    public DocumentModel getDocumentModel() {
        return this.getEtatModel().getParent();
    }

    public void setPluginModel(PluginModel model) {
        this.model = model;
    }

    public PluginModel getPluginModel() {
        return this.model;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    public void setListeResultatModel(ListeResultatModel lrm) {
        this.lrm = lrm;
    }

    public ListeResultatModel getListeResultat() {
        return this.lrm;
    }

    public void setParameters(Hashtable<String, String> params) {
        this.params = params;
    }

    public Hashtable<String, String> getParameters() {
        return this.params;
    }

    public abstract DataResultSet getResultSet() throws Exception;

    public static String convertOpString(String op, String val) {
        if ("starts-with".equals(op)) {
            return " like '" + val + "%' ";
        }
        if ("contains".equals(op)) {
            return " like '%" + val + "%' ";
        }
        if ("xem:ends-with".equals(op)) {
            return " like '%" + val + "' ";
        }
        if ("xem:StringEquals".equals(op)) {
            return " like '" + val + "' ";
        }
        if ("xem:StringDiffers".equals(op)) {
            return " <> '" + val + "' ";
        }
        if ("xem:StringIsNull".equals(op)) {
            return " = '' ";
        }
        if ("xem:StringIsNotNull".equals(op)) {
            return " <> '' ";
        }
        return "";
    }
}

