/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.importers.docetatProvider;

import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.NSModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ParameterModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ParametersModel;
import fr.gouv.finances.dgfip.xemelios.importers.DefaultImporter;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.AbstractWriter;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.AttributeHolder;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.AttributesHolder;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.NamespaceHolder;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.NodeHolder;
import fr.gouv.finances.dgfip.xemelios.importers.docetatProvider.NodesHolder;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class DocEtatProviderImporter
extends DefaultImporter {
    private static final Logger logger = Logger.getLogger(DocEtatProviderImporter.class);
    private static final transient String STOP_PARSING_MESSAGE = "STOP_PARSING_PATH reached";

    public DocEtatProviderImporter(XemeliosUser user) {
        super(user);
    }

    protected FileInfo importFile(File f) throws Exception {
        SAXParser parser;
        ParserReader pr;
        NodesHolder nodeHolder;
        AttributesHolder attHolder;
        ParametersModel params;
        String fileEncoding;
        File outputTmpFile;
        block9: {
            outputTmpFile = new File(FileUtils.getTempDir(), f.getName());
            if (outputTmpFile.exists()) {
                outputTmpFile.delete();
            }
            this.getImpSvcProvider().startLongWait();
            fileEncoding = DocEtatProviderImporter.getFileEncoding(f);
            String xmlVersion = DocEtatProviderImporter.getFileXmlVersion(f);
            params = this.getDocumentModel().getParameters();
            attHolder = new AttributesHolder();
            nodeHolder = new NodesHolder();
            HashSet<String> attrNames = new HashSet<String>();
            HashSet<String> nodeNames = new HashSet<String>();
            for (ParameterModel pm : params.getParameters()) {
                String nodeId;
                String[] ss;
                if (pm.getName().startsWith("attribute.")) {
                    ss = pm.getName().split("\\.");
                    String attrId = ss[1];
                    if (attrNames.contains(attrId)) continue;
                    String attrLocation = params.getParameter("attribute." + attrId + ".location").getValue();
                    String attrXPath = params.getParameter("attribute." + attrId + ".value").getValue();
                    String attrName = params.getParameter("attribute." + attrId + ".name").getValue();
                    attHolder.addAttribute(new AttributeHolder(attrId, attrName, attrLocation, attrXPath));
                    attrNames.add(attrId);
                    continue;
                }
                if (!pm.getName().startsWith("node.") || nodeNames.contains(nodeId = (ss = pm.getName().split("\\."))[1])) continue;
                String copyFrom = params.getParameter("node." + nodeId + ".copyFrom").getValue();
                String copyTo = params.getParameter("node." + nodeId + ".copyTo").getValue();
                nodeHolder.addNode(new NodeHolder(copyFrom, copyTo));
                nodeNames.add(nodeId);
            }
            String stopParsingPath = params.getParameter("stop.parsing") != null ? params.getParameter("stop.parsing").getValue() : null;
            pr = new ParserReader(attHolder, nodeHolder, stopParsingPath, this.getDocumentModel());
            SAXParserFactory sf = SAXParserFactory.newInstance();
            sf.setNamespaceAware(true);
            parser = sf.newSAXParser();
            try {
                parser.parse(f, (DefaultHandler)pr);
            }
            catch (SAXException saxEx) {
                if (STOP_PARSING_MESSAGE.equals(saxEx.getMessage())) break block9;
                throw saxEx;
            }
        }
        FileOutputStream fos = new FileOutputStream(outputTmpFile);
        String abstractWriterClassName = params.getParameter("abstract.writer").getValue();
        AbstractWriter pw = null;
        try {
            Class<?> clazz = Class.forName(abstractWriterClassName);
            Constructor<?> cc = clazz.getConstructor(DocumentModel.class, OutputStream.class, String.class, AttributesHolder.class, NodesHolder.class, NamespaceHolder.class);
            pw = (AbstractWriter)cc.newInstance(this.dm, fos, fileEncoding, attHolder, nodeHolder, pr.getNS());
        }
        catch (Exception ex) {
            logger.error((Object)("while instancing " + abstractWriterClassName), (Throwable)ex);
        }
        try {
            parser.parse(f, pw);
        }
        catch (SAXException saxEx) {
            logger.error((Object)"file not well-formed", (Throwable)saxEx);
        }
        fos.flush();
        fos.close();
        this.getImpSvcProvider().endLongWait();
        FileInfo ret = super.importFile(outputTmpFile);
        return ret;
    }

    private class ParserReader
    extends DefaultHandler2 {
        private final Logger logger = Logger.getLogger(ParserReader.class);
        private Document doc;
        private AttributesHolder attHolder;
        private NodesHolder nodeHolder;
        private Stack<QName> stack;
        private NamespaceHolder ns;
        private String stopParsingPath;
        private Element currentNode;
        private boolean generatingDom = false;

        public ParserReader(AttributesHolder attHolder, NodesHolder nodeHolder, String stopParsingPath, DocumentModel dm) {
            this.attHolder = attHolder;
            this.nodeHolder = nodeHolder;
            this.stack = new Stack();
            this.ns = new NamespaceHolder();
            this.stopParsingPath = stopParsingPath;
            try {
                this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (Exception ex) {
                this.logger.error((Object)"ParserReader.<init>", (Throwable)ex);
            }
            for (NSModel n : dm.getNamespaces().getMappings()) {
                this.ns.addMapping(n.getPrefix(), n.getUri());
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            QName name = new QName(uri, localName);
            this.stack.push(name);
            String xpath = this.getXPath();
            for (int i = 0; i < attributes.getLength(); ++i) {
                StringBuilder attName = new StringBuilder();
                String prefix = this.ns.getPrefix(attributes.getURI(i));
                if (prefix != null && prefix.length() > 0) {
                    attName.append(prefix).append(":");
                }
                attName.append(attributes.getLocalName(i));
                attName.insert(0, "/@");
                attName.insert(0, xpath);
                String attPath = attName.toString();
                this.attHolder.setAttValue(attPath, attributes.getValue(i));
            }
            if (this.nodeHolder.exists(xpath) || this.generatingDom) {
                Element el = this.doc.createElementNS(uri, qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr at = this.doc.createAttributeNS(attributes.getURI(i), attributes.getQName(i));
                    at.setValue(attributes.getValue(i));
                    el.setAttributeNodeNS(at);
                }
                if (this.generatingDom) {
                    this.currentNode.appendChild(el);
                    this.currentNode = el;
                } else {
                    this.currentNode = el;
                    this.generatingDom = true;
                }
            }
            if (xpath.equals(this.stopParsingPath)) {
                throw new SAXException(DocEtatProviderImporter.STOP_PARSING_MESSAGE);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.ns.addMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.ns.removeMapping(prefix);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String xpath = this.getXPath();
            QName name = this.stack.pop();
            if (this.generatingDom && this.currentNode.getParentNode() != null) {
                this.currentNode = (Element)this.currentNode.getParentNode();
            }
            if (this.nodeHolder.exists(xpath)) {
                this.nodeHolder.setValueAt(xpath, this.currentNode);
                this.generatingDom = false;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.generatingDom && this.currentNode != null) {
                Text txt = this.doc.createTextNode(new String(ch, start, length));
                this.currentNode.appendChild(txt);
            }
        }

        String getXPath() {
            StringBuilder sb = new StringBuilder();
            for (QName qn : this.stack) {
                sb.append("/");
                String prefix = this.ns.getPrefix(qn.getNamespaceURI());
                if (prefix != null && prefix.length() > 0) {
                    sb.append(prefix).append(":");
                }
                sb.append(qn.getLocalPart());
            }
            return sb.toString();
        }

        NamespaceHolder getNS() {
            return this.ns;
        }
    }
}

