/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.importers;

import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ParameterModel;
import fr.gouv.finances.dgfip.xemelios.importers.DefaultImporter;
import fr.gouv.finances.dgfip.xemelios.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;

public class ImporterWithXSLBeforeSplitFile
extends DefaultImporter {
    public ImporterWithXSLBeforeSplitFile(XemeliosUser user) {
        super(user);
    }

    public void setDocument(DocumentModel dm) {
        this.dm = dm;
    }

    protected FileInfo importFile(File f) throws Exception {
        this.getImpSvcProvider().startLongWait();
        File fTmp = f;
        for (ParameterModel pm : this.dm.getParameters().getParameters()) {
            if (!"pre-split-xsl-file".equals(pm.getName())) continue;
            File tmpDest = new File(FileUtils.getTempDir(), fTmp.getName());
            FileOutputStream fos = new FileOutputStream(tmpDest);
            StreamResult sr = new StreamResult(fos);
            Transformer trans = TransformerFactoryImpl.newInstance().newTransformer(new StreamSource(new File(new File(this.dm.getBaseDirectory()), pm.getValue())));
            trans.transform(new StreamSource(f), sr);
            fos.flush();
            fos.close();
            fTmp = tmpDest;
        }
        this.getImpSvcProvider().endLongWait();
        return super.importFile(fTmp);
    }
}

