/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.impl.pool.impl;

import fr.gouv.finances.dgfip.xemelios.data.impl.pool.Pool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.log4j.Logger;

public class DbcpPool
implements Pool {
    private static final Logger logger = Logger.getLogger(DbcpPool.class);
    private DataSource dataSource;

    public DbcpPool(Properties props) {
        this.initDataSource(props);
    }

    protected void initDataSource(Properties props) {
        try {
            this.dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseConnection(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean shutdown() throws SQLException {
        logger.info((Object)"shutdown");
        ((BasicDataSource)this.getDataSource()).close();
        return true;
    }

    public int getNumActive() {
        return ((BasicDataSource)this.getDataSource()).getNumActive();
    }

    public int getNumIdle() {
        return ((BasicDataSource)this.getDataSource()).getNumIdle();
    }
}

