/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.CollectiviteInfosModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.dgfip.xemelios.common.config.XPathModel;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParentModel
implements NoeudModifiable,
Comparable {
    public static final transient String TAG = "parent-coll";
    public static final transient QName QN = new QName("parent-coll");
    private String id;
    private String libelle;
    private int level = -1;
    private CollectiviteInfosModel parent;
    private XPathModel codePath;
    private XPathModel libellePath;

    public ParentModel(QName tagName) {
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this.parent;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this.parent = (CollectiviteInfosModel)p;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if (DocumentsMapping.CODE_PATH.getLocalPart().equals(tagName)) {
            return this.codePath;
        }
        return this.libellePath;
    }

    public void modifyAttr(String attrName, String value) {
        if ("id".equals(attrName)) {
            this.id = value;
        } else if ("libelle".equals(attrName)) {
            this.libelle = value;
        }
    }

    public void modifyAttrs(Attributes attrs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getChildIdAttrName(String childTagName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetCharData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIdValue() {
        return "id";
    }

    public String getConfigXPath() {
        return this.parent.getConfigXPath() + "/" + TAG + "[@level=" + this.level + "]";
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tag) throws SAXException {
        if (DocumentsMapping.CODE_PATH.equals(tag)) {
            this.codePath = (XPathModel)child;
            this.codePath.setParent(this);
        } else if (DocumentsMapping.LIBELLE_PATH.equals(tag)) {
            this.libellePath = (XPathModel)child;
            this.libellePath.setParent(this);
        } else {
            throw new SAXException("Unexpected child for " + this.getConfigXPath() + ": " + tag.toString());
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        if (attributes.getValue("level") != null) {
            this.level = attributes.getIntValue("level");
        }
        return this;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return this.getChildAsNoeudModifiable(qName, null);
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("libelle", this.libelle);
        output.addAttribute("level", this.level);
        this.codePath.marshall(output);
        this.libellePath.marshall(output);
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.level == -1) {
            throw new InvalidXmlDefinition(this.getConfigXPath() + "/@level must be >= 1");
        }
    }

    public QName getQName() {
        return QN;
    }

    public ParentModel clone() {
        ParentModel other = new ParentModel(QN);
        other.setId(this.getId());
        other.setLibelle(this.getLibelle());
        other.setLevel(this.getLevel());
        try {
            other.addChild((XmlMarshallable)this.codePath.clone(), DocumentsMapping.CODE_PATH);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            other.addChild((XmlMarshallable)this.libellePath.clone(), DocumentsMapping.LIBELLE_PATH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return other;
    }

    public XPathModel getCodePath() {
        return this.codePath;
    }

    public void setCodePath(XPathModel codePath) {
        this.codePath = codePath;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public XPathModel getLibellePath() {
        return this.libellePath;
    }

    public void setLibellePath(XPathModel libellePath) {
        this.libellePath = libellePath;
    }

    public CollectiviteInfosModel getParent() {
        return this.parent;
    }

    public void setParent(CollectiviteInfosModel parent) {
        this.parent = parent;
    }

    public int compareTo(Object o) {
        if (o instanceof ParentModel) {
            ParentModel other = (ParentModel)o;
            return this.getLevel() - other.getLevel();
        }
        return -1;
    }

    public String toString() {
        return this.getLibelle();
    }
}

