/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.dgfip.xemelios.common.config.ParentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RecherchePaireModel;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CollectiviteInfosModel
extends RecherchePaireModel {
    public static final transient String TAG = "collectivite-path";
    public static final transient QName QN = new QName("collectivite-path");
    private TreeSet<ParentModel> parents = new TreeSet();

    public CollectiviteInfosModel(QName tagName) {
        super(tagName);
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (DocumentsMapping.PATH.equals(tagName)) {
            super.addChild(child, tagName);
        } else if (DocumentsMapping.CODE_PATH.equals(tagName)) {
            super.addChild(child, tagName);
        } else if (DocumentsMapping.LIBELLE_PATH.equals(tagName)) {
            super.addChild(child, tagName);
        } else if (ParentModel.QN.equals(tagName)) {
            ParentModel pm = (ParentModel)child;
            pm.setParentAsNoeudModifiable(this);
            this.parents.add(pm);
        }
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        if (ParentModel.QN.getLocalPart().equals("qName")) {
            String sll = atts.getValue("level");
            int i = -1;
            try {
                i = Integer.parseInt(sll);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (i > 0) {
                return (XmlMarshallable)this.parents.toArray()[i - 1];
            }
            return null;
        }
        return super.getChildToModify(uri, localName, qName, atts);
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("sort", this.getSortBy());
        if (this.getPath() != null) {
            this.getPath().marshall(output);
        }
        if (this.getCodePath() != null) {
            this.getCodePath().marshall(output);
        }
        if (this.getLibellePath() != null) {
            this.getLibellePath().marshall(output);
        }
        for (ParentModel p : this.parents) {
            p.marshall(output);
        }
        output.endTag(TAG);
    }

    public int getParentsCount() {
        return this.parents.size();
    }

    public ParentModel getParent(int i) {
        return (ParentModel)this.parents.toArray()[i];
    }

    public CollectiviteInfosModel clone() {
        CollectiviteInfosModel other = new CollectiviteInfosModel(QN);
        other.setId(this.getId());
        if (this.getPath() != null) {
            try {
                other.addChild((XmlMarshallable)this.getPath().clone(), DocumentsMapping.PATH);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            other.addChild((XmlMarshallable)this.getCodePath().clone(), DocumentsMapping.CODE_PATH);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            other.addChild((XmlMarshallable)this.getLibellePath().clone(), DocumentsMapping.LIBELLE_PATH);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (Object o : this.parents.toArray()) {
            ParentModel pm = (ParentModel)o;
            try {
                other.addChild((XmlMarshallable)pm.clone(), ParentModel.QN);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return other;
    }

    public void validate() throws InvalidXmlDefinition {
        super.validate();
        if (!this.parents.isEmpty()) {
            Iterator<ParentModel> it = this.parents.iterator();
            ParentModel pm = it.next();
            for (int i = 1; i <= this.parents.size(); ++i) {
                if (pm.getLevel() != i) {
                    throw new InvalidXmlDefinition(pm.getConfigXPath() + " levels must start at 1 and be consecutives");
                }
                if (i >= this.parents.size()) continue;
                pm = it.next();
            }
        }
    }
}

