/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common;

import fr.gouv.finances.dgfip.xemelios.common.Scramble;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import java.net.InetAddress;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.log4j.Logger;

public class NetAccess {
    private static final transient Logger logger = Logger.getLogger(NetAccess.class);

    public static HttpClient getHttpClient() throws DataConfigurationException {
        String proxyHost = System.getProperty("xemelios.proxy.server");
        String proxyPort = System.getProperty("xemelios.proxy.port");
        String proxyUser = System.getProperty("xemelios.proxy.user");
        String sTmp = System.getProperty("xemelios.proxy.password");
        String proxyPasswd = sTmp != null ? Scramble.unScramblePassword(sTmp) : null;
        int intProxyPort = 0;
        if (proxyPort != null) {
            try {
                intProxyPort = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException nfEx) {
                throw new DataConfigurationException(proxyPort + " n'est pas un num\u00e9ro de port valide.");
            }
        }
        String domainName = System.getProperty("xemelios.proxy.domain");
        HttpClient client = new HttpClient();
        HostConfiguration hc = new HostConfiguration();
        if (proxyHost != null) {
            hc.setProxy(proxyHost, intProxyPort);
            client.setHostConfiguration(hc);
        }
        if (proxyUser != null) {
            UsernamePasswordCredentials creds = null;
            if (domainName != null && domainName.length() > 0) {
                String hostName = "127.0.0.1";
                try {
                    InetAddress ip = InetAddress.getByName("127.0.0.1");
                    hostName = ip.getHostName();
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
                creds = new NTCredentials(proxyUser, proxyPasswd, hostName, domainName);
            } else {
                creds = new UsernamePasswordCredentials(proxyUser, proxyPasswd);
            }
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)creds);
        }
        return client;
    }
}

