/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.auth;

import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public interface AuthEngine {
    public boolean isLoginRequired();

    public boolean isPasswordRequired();

    public XemeliosUser createUser(String var1, String var2);

    public static class Helper {
        private static final int ROLE_CONNECT_BIT = 1;
        private static final int ROLE_IMPORT_BIT = 2;
        private static final int ROLE_CLEAN_BIT = 4;
        private static final int ROLE_SEARCH_BIT = 16;
        private static final int ROLE_BROWSE_BIT = 32;
        private static final int ROLE_EXPORT_BIT = 64;

        public static Set rolesFromInt(int rolesAsInt) {
            HashSet<String> toReturn = new HashSet<String>();
            if ((rolesAsInt & 0x20) > 0) {
                toReturn.add("BROWSE");
            }
            if ((rolesAsInt & 4) > 0) {
                toReturn.add("CLEAN");
            }
            if ((rolesAsInt & 1) > 0) {
                toReturn.add("CONNECT");
            }
            if ((rolesAsInt & 0x40) > 0) {
                toReturn.add("EXPORT");
            }
            if ((rolesAsInt & 2) > 0) {
                toReturn.add("IMPORT");
            }
            if ((rolesAsInt & 0x10) > 0) {
                toReturn.add("SEARCH");
            }
            return toReturn;
        }
    }

    public static class Holder {
        private static final Logger logger = Logger.getLogger(Holder.class);
        private static final String DEFAULT_AUTH_ANGINE_CLASS_NAME_PROPERTY = "authEngineClassName";
        private static final String DEFAULT_AUTH_ENGINE_CLASS_NAME = "fr.gouv.finances.dgfip.xemelios.auth.impl.std.db.StdDbAuthEngineImpl";
        private static AuthEngine authEngine;

        public static void init() {
            Holder.init(DEFAULT_AUTH_ANGINE_CLASS_NAME_PROPERTY);
        }

        public static void init(String propertyName) {
            try {
                String authEngineClassName = DataLayerManager.getImplementation().getParameterValue(propertyName);
                if (authEngineClassName == null) {
                    authEngineClassName = DEFAULT_AUTH_ENGINE_CLASS_NAME;
                }
                Class<?> authEngineclass = Class.forName(authEngineClassName);
                authEngine = (AuthEngine)authEngineclass.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"auth start: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public static AuthEngine getAuthEngine() {
            return authEngine;
        }
    }
}

