/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.utils.xml;

import fr.gouv.finances.dgfip.utils.xml.InvalidPathExpressionException;
import java.util.StringTokenizer;

public class XWay {
    private String path;

    public XWay() {
    }

    public XWay(String path) throws InvalidPathExpressionException {
        if (path == null) {
            throw new InvalidPathExpressionException("path can not be null");
        }
        if (path.charAt(0) != '/') {
            throw new InvalidPathExpressionException("relative path not allowed");
        }
        if (path.endsWith("/")) {
            throw new InvalidPathExpressionException("path can not end with \"/\"");
        }
        this.path = path;
    }

    public XWay append(String path) throws InvalidPathExpressionException {
        if (path == null) {
            throw new InvalidPathExpressionException("path can not be null");
        }
        if (path.startsWith("/")) {
            return new XWay(path);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuilder sb = new StringBuilder(this.path);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("..")) {
                sb = XWay.upOneLevel(sb.toString());
                continue;
            }
            if (token.equals(".")) continue;
            sb.append("/").append(token);
        }
        return new XWay(sb.toString());
    }

    private static StringBuilder upOneLevel(String path) {
        int pos = path.lastIndexOf(47);
        return new StringBuilder(path.substring(0, pos));
    }

    public String toString() {
        return this.path;
    }

    public static String compactXPath(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("..")) {
                sb = XWay.upOneLevel(sb.toString());
                continue;
            }
            if (token.equals(".")) continue;
            sb.append("/").append(token);
        }
        return sb.toString();
    }
}

