/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.cge.linkResolver;

import fr.gouv.finances.dgfip.utils.NavigationContext;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.transform.CustomURIResolver;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.common.config.customLinks.CustomLinkParameters;
import fr.gouv.finances.dgfip.xemelios.common.config.customLinks.CustomLinkResolver;
import fr.gouv.finances.dgfip.xemelios.common.config.customLinks.UnresolvedException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class CGECustomLinkResolver
extends CustomLinkResolver {
    private static final Logger logger = Logger.getLogger(CGECustomLinkResolver.class);

    public CGECustomLinkResolver() {
        logger.debug((Object)"instanciating");
    }

    public NavigationContext resolve(CustomLinkParameters parameters, Result result, NavigationContext ctx, XemeliosUser user) throws DataConfigurationException, UnresolvedException {
        logger.debug((Object)"in resolve(CustomLinkParameters,Result,NavigationContext,XemeliosUser)");
        if (parameters.getSrcDocId().equals("compteGestionEtat") && parameters.getSrcEtatId().equals("BalanceGenerale")) {
            this.treatBalanceGenerale(parameters, ctx);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getSrcDocId().equals("compteGestionEtat") && parameters.getSrcEtatId().equals("FichesBudgetaires")) {
            this.treatFichesBudgetaires(parameters, ctx);
            this.commonTreatment(parameters, ctx, result, user);
        } else if (parameters.getSrcDocId().equals("compteGestionEtat") && parameters.getSrcEtatId().equals("DeveloppementDepense")) {
            this.treatAnnexeIIEdmn(parameters, ctx, user);
            this.commonTreatment(parameters, ctx, result, user);
        }
        return ctx;
    }

    private void commonTreatment(CustomLinkParameters parameters, NavigationContext ctx, Result result, XemeliosUser user) throws UnresolvedException, DataConfigurationException {
        logger.debug((Object)"in commontTreatment(CustomLinkParameters,NavigationContext,Result,XemeliosUser)");
        try {
            ArrayList documents;
            DataImpl impl = DataLayerManager.getImplementation();
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(ctx.getDocId());
            EtatModel em = dm.getEtatById(ctx.getEtatId());
            ElementModel element = em.getElementById(ctx.getElementId());
            File xslFile = null;
            xslFile = new File(new File(new File(System.getProperty("user.home")), "xemelios/documents-def-ovrrd"), element.getXslt());
            if (!xslFile.exists()) {
                xslFile = new File(em.getParent().getBaseDirectory(), element.getXslt());
            }
            FileInputStream fis = new FileInputStream(xslFile);
            String docId = null;
            if (ctx.getPath() == null) {
                documents = impl.getDocumentListFromSpecialKeys(element, ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), user);
                if (documents.size() == 0) {
                    throw new UnresolvedException("Le document est introuvable.");
                }
                if (documents.size() > 1 && !em.isMultiPage()) {
                    throw new UnresolvedException("Plusieurs documents r\u00e9pondant \u00e0 ces crit\u00e8res ont \u00e9t\u00e9 trouv\u00e9s.");
                }
                docId = (String)documents.get(0);
            } else {
                if (ctx.getElementId() == null) {
                    ctx.setElementId(element.getId());
                }
                if (ctx.getPath() != null && ctx.getPath().startsWith("[")) {
                    ctx.setPath(element.getPath().getFormattedPath() + ctx.getPath());
                }
                if ((documents = impl.getDocumentListFromXPath(element, ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), ctx.getPath(), user)).size() == 0) {
                    throw new UnresolvedException("Ce compte n'est associ\u00e9 a aucun(e) " + ctx.getEtatId() + ".");
                }
                docId = documents.size() > 1 ? (String)documents.get(0) : (String)documents.get(0);
            }
            Document doc = impl.getDocumentAsDom(em, new Pair(ctx.getCollectivite(), null), new Pair(ctx.getBudget(), null), docId, user);
            TransformerFactory tFactory = TransformerFactoryImpl.newInstance();
            tFactory.setURIResolver((URIResolver)new CustomURIResolver(tFactory.getURIResolver(), xslFile.getParentFile().toURI().toURL().toExternalForm()));
            Transformer t = tFactory.newTransformer(new StreamSource(xslFile));
            for (String key : parameters.getParameters().keySet()) {
                if (!key.startsWith("xsl:param")) continue;
                String paramValue = parameters.getParameter(key);
                int virg = paramValue.indexOf(44);
                String pName = paramValue.substring(1, virg);
                String pValue = paramValue.substring(virg + 1, paramValue.length() - 1);
                t.setParameter(pName, pValue);
            }
            t.transform(new DOMSource(doc), result);
        }
        catch (UnresolvedException unEx) {
            throw unEx;
        }
        catch (Exception e) {
            logger.error((Object)"commontTreatment(CustomLinkParameters,NavigationContext,Result,XemeliosUser)", (Throwable)e);
            throw new DataConfigurationException((Throwable)e);
        }
    }

    private void treatAnnexeIIEdmn(CustomLinkParameters parameters, NavigationContext ctx, XemeliosUser user) throws UnresolvedException {
        try {
            DocumentModel dm;
            EtatModel em;
            ElementModel element;
            ArrayList documents;
            DataImpl impl = DataLayerManager.getImplementation();
            String exercice = parameters.getParameter("exercice");
            String comptable = parameters.getParameter("comptable");
            String ministere = parameters.getParameter("ministere");
            String programme = parameters.getParameter("programme");
            String articleExec = parameters.getParameter("articleExec");
            ctx.setDocId("edmn");
            ctx.setEtatId("etatEdmn");
            ctx.setElementId("ligneEdmn");
            ctx.setSp1(exercice);
            if (parameters.getSrcCollectivite() != null) {
                ctx.setCollectivite("000000000000");
            }
            if (parameters.getSrcBudget() != null) {
                ctx.setBudget("0000");
            }
            if ((documents = impl.getDocumentListFromXPath(element = (em = (dm = Loader.getDocumentsInfos(null).getDocumentById(ctx.getDocId())).getEtatById(ctx.getEtatId())).getElementById(ctx.getElementId()), ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), ctx.getPath(), user)).size() == 0) {
                ctx.setCollectivite(comptable);
                ctx.setBudget("00");
            }
            StringBuffer path = new StringBuffer("[");
            path.append("n:Comptable/@V=").append(comptable).append(" and n:Ministere/@V=").append(ministere).append(" and n:ChapBudg/@V=").append(programme).append(" and n:ArtBudgExec/@V=").append(articleExec).append("]");
            ctx.setPath(path.toString());
        }
        catch (Exception e) {
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatFichesBudgetaires(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void treatBalanceGenerale(CustomLinkParameters parameters, NavigationContext ctx) {
        try {
            logger.debug((Object)"in treatBalanceGenerale(CustomLinkParameters parameters,NavigationContext ctx)");
            DocumentModel dm = Loader.getDocumentsInfos(null).getDocumentById(ctx.getDocId());
            String baseDir = dm.getBaseDirectory();
            File f = new File(baseDir, dm.getParameters().getParameter("liens.balance").getValue());
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document LiensBalance = db.parse(f);
            String CodRD = parameters.getParameter("CodRD") != null ? parameters.getParameter("CodRD") : "";
            String numCompte = parameters.getParameter("numCompte");
            ctx.setDocId("compteGestionEtat");
            if (parameters.getSrcCollectivite() != null) {
                ctx.setCollectivite(parameters.getSrcCollectivite());
            }
            if (parameters.getSrcBudget() != null) {
                ctx.setBudget(parameters.getSrcBudget());
            }
            if (parameters.getParameter("sp1") != null) {
                ctx.setSp1(parameters.getParameter("sp1"));
            }
            if (parameters.getParameter("sp2") != null) {
                ctx.setSp2(parameters.getParameter("sp2"));
            }
            if (parameters.getParameter("sp3") != null) {
                ctx.setSp3(parameters.getParameter("sp3"));
            }
            if (numCompte != null) {
                if (numCompte.startsWith("1")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]");
                } else if (numCompte.startsWith("2")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]");
                } else if ((numCompte.startsWith("4") || numCompte.startsWith("5")) && !numCompte.startsWith("48") && !numCompte.startsWith("49")) {
                    XPath xp = XPathFactory.newInstance().newXPath();
                    String compteGestionEtat = parameters.getParameter("cg");
                    String typeLien = parameters.getParameter("type");
                    String etatSolde = xp.evaluate("/Editions/Comptes[@Edition='" + compteGestionEtat + "']/Compte[@Numero='" + numCompte + "']/@Solde", LiensBalance.getDocumentElement());
                    String etatDebit = xp.evaluate("/Editions/Comptes[@Edition='" + compteGestionEtat + "']/Compte[@Numero='" + numCompte + "']/@Debit", LiensBalance.getDocumentElement());
                    String etatCredit = xp.evaluate("/Editions/Comptes[@Edition='" + compteGestionEtat + "']/Compte[@Numero='" + numCompte + "']/@Credit", LiensBalance.getDocumentElement());
                    if (etatSolde != null && !etatSolde.equals("") && typeLien.equals("solde")) {
                        String path = "";
                        if (etatSolde.equals("ERAR") || etatSolde.equals("ERAP")) {
                            path = etatSolde.equals("ERAR") ? path + "[n:EnteteSolde/@Type='RAR']" : path + "[n:EnteteSolde/@Type='RAP']";
                            etatSolde = "Solde";
                        }
                        ctx.setEtatId(etatSolde);
                        ctx.setElementId("Page" + etatSolde);
                        path = path + "[n:Entete" + etatSolde + "/@NumCompte=" + numCompte + "]";
                        if (!(CodRD == null || CodRD.equals("") || etatSolde.equals("DeveloppementSoldes") || etatSolde.equals("Solde") || etatSolde.equals("LivreAuxiliaire"))) {
                            path = path + "[n:Entete" + etatSolde + "/@CodRD=" + CodRD + "]";
                        }
                        ctx.setPath(path);
                    } else if (etatCredit != null && !etatCredit.equals("") && typeLien.equals("totaux") && CodRD != null && CodRD.equals("R")) {
                        String path = "";
                        if (etatCredit.equals("ERAR") || etatCredit.equals("ERAP")) {
                            path = etatCredit.equals("ERAR") ? path + "[n:EnteteSolde/@Type='RAR']" : path + "[n:EnteteSolde/@Type='RAP']";
                            etatCredit = "Solde";
                        }
                        ctx.setEtatId(etatCredit);
                        ctx.setElementId("Page" + etatCredit);
                        path = path + "[n:Entete" + etatCredit + "/@NumCompte=" + numCompte + "]";
                        if (!(CodRD == null || CodRD.equals("") || etatCredit.equals("DeveloppementSoldes") || etatCredit.equals("Solde") || etatCredit.equals("LivreAuxiliaire"))) {
                            path = path + "[n:Entete" + etatCredit + "/@CodRD=" + CodRD + "]";
                        }
                        ctx.setPath(path);
                    } else if (etatDebit != null && !etatDebit.equals("") && typeLien.equals("totaux") && CodRD != null && CodRD.equals("D")) {
                        String path = "";
                        if (etatDebit.equals("ERAR") || etatDebit.equals("ERAP")) {
                            path = etatDebit.equals("ERAR") ? path + "[n:EnteteSolde/@Type='RAR']" : path + "[n:EnteteSolde/@Type='RAP']";
                            etatDebit = "Solde";
                        }
                        ctx.setEtatId(etatDebit);
                        ctx.setElementId("Page" + etatDebit);
                        path = path + "[n:Entete" + etatDebit + "/@NumCompte=" + numCompte + "]";
                        if (!(CodRD == null || CodRD.equals("") || etatDebit.equals("DeveloppementSoldes") || etatDebit.equals("Solde") || etatDebit.equals("LivreAuxiliaire"))) {
                            path = path + "[n:Entete" + etatDebit + "/@CodRD=" + CodRD + "]";
                        }
                        ctx.setPath(path);
                    } else {
                        ctx.setEtatId("LivreAuxiliaire");
                        ctx.setElementId("PageLivreAuxiliaire");
                        ctx.setPath("[n:EnteteLivreAuxiliaire/@NumCompte=" + numCompte + "]");
                    }
                } else if (numCompte.startsWith("48")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "R" : "D";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]");
                } else if (numCompte.startsWith("49")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "R" : "D";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]");
                } else if (numCompte.startsWith("6")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "R" : "D";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]");
                } else if (numCompte.startsWith("7")) {
                    ctx.setEtatId("FichesBudgetaires");
                    ctx.setElementId("PageFichesBudgetaires");
                    CodRD = numCompte.contains("9") ? "D" : "R";
                    ctx.setPath("[n:EnteteFichesBudgetaires/@NumCompte=" + numCompte + "][n:EnteteFichesBudgetaires/@CodRD=" + CodRD + "]");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void treatFichesBudgetaires(CustomLinkParameters parameters, NavigationContext ctx) throws UnresolvedException {
        try {
            String codRD = parameters.getParameter("codRD");
            String exercice = parameters.getParameter("exercice");
            String mtEmis = parameters.getParameter("mtEmis");
            String mtAnn = parameters.getParameter("mtAnn");
            String mandatId = parameters.getParameter("mandatId");
            ctx.setDocId("PES_Aller");
            if (codRD.equals("D")) {
                ctx.setEtatId("PES_DepenseAller");
                ctx.setElementId("Piece");
            } else {
                ctx.setEtatId("PES_RecetteAller");
                ctx.setElementId("PieceRecette");
            }
            if (parameters.getSrcCollectivite() != null) {
                ctx.setCollectivite(parameters.getSrcCollectivite());
            }
            if (parameters.getSrcBudget() != null) {
                ctx.setBudget(parameters.getSrcBudget());
            }
            if (ctx.getSp1() != null) {
                ctx.setSp1(null);
            }
            String typeBordereau = "";
            if (mtEmis != null && mtEmis.length() > 0) {
                typeBordereau = "01";
            } else if (mtAnn != null && mtAnn.length() > 0) {
                typeBordereau = "02";
            }
            StringBuffer path = new StringBuffer();
            path.append("[../n:BlocBordereau/n:Exer/@V=").append(exercice).append("][../n:BlocBordereau/n:TypBord/@V=").append(typeBordereau).append("]");
            if ("D".equals(codRD)) {
                path.append("[n:BlocPiece/n:InfoPce/n:IdPce/@V=").append(mandatId).append("]");
            } else {
                path.append("[n:BlocPiece/n:IdPce/@V=").append(mandatId).append("]");
            }
            ctx.setPath(path.toString());
        }
        catch (Exception e) {
            logger.debug((Object)"Erreur", (Throwable)e);
            throw new UnresolvedException("treatFichesBudgetaires(CustomLinkParameters parameters,NavigationContext ctx)");
        }
    }

    private void debug(Document doc) {
        try {
            Transformer t = TransformerFactoryImpl.newInstance().newTransformer();
            t.transform(new DOMSource(doc), new StreamResult(System.out));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

