/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.FileNode;

public class FileSystemModel
extends DefaultTreeTableModel {
    private static final Logger LOG = Logger.getLogger(FileSystemModel.class.getName());
    protected boolean asksAllowsChildren;
    private static final Integer ZERO = new Integer(0);

    public FileSystemModel() {
        this(new FileNode(new File(File.separator)));
    }

    public FileSystemModel(TreeNode treeNode) {
        this(treeNode, false);
    }

    public FileSystemModel(TreeNode treeNode, boolean bl) {
        super(treeNode);
        this.asksAllowsChildren = bl;
    }

    public Object getChild(Object object, int n) {
        try {
            return ((FileNode)object).getChildren().get(n);
        }
        catch (Exception exception) {
            return super.getChild(object, n);
        }
    }

    public int getChildCount(Object object) {
        try {
            return ((FileNode)object).getChildren().size();
        }
        catch (Exception exception) {
            return super.getChildCount(object);
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return "Column " + n;
    }

    public Object getValueAt(Object object, int n) {
        File file = ((FileNode)object).getFile();
        try {
            switch (n) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? new Integer((int)file.length()) : ZERO;
                }
                case 2: {
                    return new Boolean(!file.isFile());
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem accessing file", exception);
        }
        return null;
    }
}

