/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;

public abstract class Filter {
    private int column;
    protected FilterPipeline pipeline = null;
    protected ComponentAdapter adapter = null;
    protected int[] fromPrevious = new int[0];
    int order = -1;

    public Filter() {
        this(0);
    }

    public Filter(int n) {
        this.column = n;
        this.init();
    }

    public void refresh() {
        this.refresh(true);
    }

    public int getColumnIndex() {
        return this.column;
    }

    public void setColumnIndex(int n) {
        if (this.getColumnIndex() == n) {
            return;
        }
        this.column = n;
        this.refresh();
    }

    public String getColumnName() {
        if (this.adapter == null) {
            return "Column " + this.column;
        }
        return this.adapter.getColumnName(this.getColumnIndex());
    }

    public int convertRowIndexToModel(int n) {
        int n2 = this.mapTowardModel(n);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            n2 = filter.convertRowIndexToModel(n2);
        }
        return n2;
    }

    public int convertRowIndexToView(int n) {
        int n2 = n;
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            n2 = filter.convertRowIndexToView(n2);
        }
        return this.mapTowardView(n2);
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.mapTowardModel(n);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getValueAt(n3, n2);
        }
        return this.adapter.getValueAt(n3, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.mapTowardModel(n);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            filter.setValueAt(object, n3, n2);
            return;
        }
        this.adapter.setValueAt(object, n3, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        int n3 = this.mapTowardModel(n);
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.isCellEditable(n3, n2);
        }
        return this.adapter.isCellEditable(n3, n2);
    }

    public abstract int getSize();

    protected int getInputSize() {
        return this.pipeline == null ? (this.adapter == null ? 0 : this.adapter.getRowCount()) : this.pipeline.getInputSize(this);
    }

    protected Object getInputValue(int n, int n2) {
        Filter filter = this.getMappingFilter();
        if (filter != null) {
            return filter.getValueAt(n, n2);
        }
        if (this.adapter != null) {
            return this.adapter.getValueAt(n, n2);
        }
        return null;
    }

    protected abstract void init();

    protected abstract void reset();

    protected abstract void filter();

    protected abstract int mapTowardModel(int var1);

    protected int mapTowardView(int n) {
        return n < 0 || n >= this.fromPrevious.length ? -1 : this.fromPrevious[n];
    }

    @Deprecated
    protected int translateFromPreviousFilter(int n) {
        return this.mapTowardView(n);
    }

    @Deprecated
    protected int translateToPreviousFilter(int n) {
        return this.mapTowardModel(n);
    }

    private Filter getMappingFilter() {
        Filter filter = null;
        if (this.pipeline != null) {
            filter = this.pipeline.previous(this);
        }
        return filter;
    }

    protected void refresh(boolean bl) {
        if (bl) {
            this.reset();
        }
        this.filter();
        if (this.pipeline != null && this.pipeline.contains(this)) {
            this.pipeline.filterChanged(this);
            return;
        }
        if (this.adapter != null) {
            this.adapter.refresh();
        }
    }

    protected void assign(ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = componentAdapter;
        } else if (this.adapter != componentAdapter) {
            throw new IllegalStateException("Already bound to another adapter");
        }
    }

    final void assign(FilterPipeline filterPipeline) {
        if (this.pipeline == null || filterPipeline == null) {
            this.pipeline = filterPipeline;
        } else if (this.pipeline != filterPipeline) {
            throw new IllegalStateException("Already bound to another pipeline");
        }
    }

    void assign(FilterPipeline filterPipeline, int n) {
        if (this.order >= 0) {
            throw new IllegalArgumentException("Element " + n + " is part of another pipeline.");
        }
        this.order = n;
        this.assign(filterPipeline);
    }

    protected FilterPipeline getPipeline() {
        return this.pipeline;
    }
}

