/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.quittancement.plugins;

import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.plugins.SearchPlugin;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VariationsTypesLignes
extends SearchPlugin {
    private static final Logger logger = Logger.getLogger(VariationsTypesLignes.class);
    protected String year1;
    protected String year2;
    protected String month1;
    protected String month2;
    protected String delta;
    protected String typeVariation;
    protected String tag;
    protected String attribute;
    protected String valeurSql = null;
    protected String codeProduit = null;
    protected int compareMethod = 0;
    protected static final int METHOD_PERCENT = 1;
    protected static final int METHOD_VALUE = 2;
    protected double limite = 0.0;

    public VariationsTypesLignes(XemeliosUser user) {
        super(user);
    }

    public void computeParameters() throws Exception {
        this.tag = "MtNet";
        this.attribute = "V";
        Vector props = this.getPluginModel().getProperties();
        for (PropertyModel property : props) {
            if (property.getName().equals("attribute")) {
                this.attribute = property.getValue();
                continue;
            }
            if (!property.getName().equals("valeur-sql")) continue;
            this.valeurSql = property.getValue();
        }
        this.year1 = (String)this.getParameters().get("VALEUR:year1");
        this.month1 = (String)this.getParameters().get("VALEUR:month1");
        this.year2 = (String)this.getParameters().get("VALEUR:year2");
        this.month2 = (String)this.getParameters().get("VALEUR:month2");
        this.delta = (String)this.getParameters().get("VALEUR:delta");
        this.limite = Double.parseDouble(this.delta);
        this.typeVariation = (String)this.getParameters().get("VALEUR:typeVariation");
        if (this.typeVariation.equals("percent")) {
            this.compareMethod = 1;
        } else if (this.typeVariation.equals("euro")) {
            this.compareMethod = 2;
        }
        if (this.getParameters().get("VALEUR:tag") != null) {
            this.tag = (String)this.getParameters().get("VALEUR:tag");
        }
        if (this.getParameters().get("VALEUR:codeProduit") != null) {
            this.codeProduit = (String)this.getParameters().get("VALEUR:codeProduit");
        }
        StringBuffer error = new StringBuffer();
        boolean hasError = false;
        if (hasError) {
            logger.error((Object)error.toString());
            throw new Exception(error.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataResultSet getResultSet() throws Exception {
        this.computeParameters();
        MySqlDataLayer dl = (MySqlDataLayer)DataLayerManager.getImplementation();
        TDocument pc = dl.getPersistenceConfig(this.getEtatModel().getParent(), this.getUser()).getLayer("mysql").getDocument(this.getEtatModel().getParent().getId());
        TEtat sec = pc.getEtat(this.getEtatModel().getId());
        StringBuilder request = new StringBuilder();
        String tableName = sec.getIndexTable("PES_FACTURE_PESFACTURE_FACTUREINDIV_IX").getBaseName();
        String lignesTableName = sec.getIndexTable("PES_FACTURE_FACTUREINDIV_LIGNEFACTURE_IX").getBaseName();
        request.append("SELECT Q1.IDTIERS||'-'||Q1.NUMEROCONTRAT FROM ").append(tableName).append(" Q1, ").append(tableName).append(" Q2, ").append(lignesTableName).append(" LQ1, ").append(lignesTableName).append(" LQ2 ");
        request.append(" WHERE Q1.COLLECTIVITE='").append(this.getCollectivite().key).append("' AND Q1.BUDGET='").append(this.getBudget().key).append("' AND Q2.COLLECTIVITE=Q1.COLLECTIVITE AND Q2.BUDGET=Q1.BUDGET AND LQ1.COLLECTIVITE=Q1.COLLECTIVITE AND LQ1.BUDGET=Q1.BUDGET AND LQ2.COLLECTIVITE=Q2.COLLECTIVITE AND LQ2.BUDGET=Q2.BUDGET ");
        request.append("AND Q1.ANNEE_DATE_EMISSION=").append(this.year1).append(" AND Q1.MOIS_DATE_EMISSION='").append(this.month1).append("' ");
        request.append("AND Q2.ANNEE_DATE_EMISSION=").append(this.year2).append(" AND Q2.MOIS_DATE_EMISSION='").append(this.month2).append("' ");
        request.append("AND Q1.IDTIERS=Q2.IDTIERS AND Q1.NUMEROCONTRAT=Q2.NUMEROCONTRAT ");
        request.append("AND LQ1.DOC_ID=Q1.DOC_ID AND LQ2.DOC_ID=Q2.DOC_ID ");
        request.append("AND LQ1.CODEPRODUIT='").append(this.codeProduit).append("' AND LQ2.CODEPRODUIT='").append(this.codeProduit).append("' ");
        String column = this.tag;
        if (this.valeurSql != null) {
            column = this.valeurSql;
        }
        if ("percent".equals(this.typeVariation)) {
            request.append("HAVING ABS((SUM(LQ2.").append(column).append(")-SUM(LQ1.").append(column).append("))/SUM(LQ1.").append(column).append(")*100)>").append(this.limite);
        } else {
            request.append("HAVING ABS(SUM(LQ2.").append(column).append(")-SUM(LQ1.").append(column).append("))>").append(this.limite);
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = dl.getConnection();
            logger.debug((Object)request.toString());
            ps = con.prepareStatement(request.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<String> matricules = new ArrayList<String>();
            while (rs.next()) {
                String matr = rs.getString(1);
                matricules.add(matr);
            }
            if (matricules.size() > 0) {
                request = new StringBuilder();
                request.append("SELECT SQL_CALC_FOUND_ROWS DOC_ID, AGENT_MATRICULE FROM ").append(tableName);
                request.append(" WHERE (( ANNEE_DATE_EMISSION=").append(this.year1).append(" AND MOIS_DATE_EMISSION='").append(this.month1).append("') OR (ANNEE_DATE_EMISSION=").append(this.year2).append(" AND MOIS_DATE_EMISSION='").append(this.month2).append("')) AND IDTIERS||'-'||NUMEROCONTRAT IN (");
                for (String s : matricules) {
                    request.append("'").append(s).append("',");
                }
                request.deleteCharAt(request.length() - 1);
                request.append(") AND COLLECTIVITE='").append(this.getCollectivite().key).append("' AND BUDGET='").append(this.getBudget().key).append("' ");
                request.append("ORDER BY IDTIERS ASC, NUMEROCONTRAT ASC, ANNEE_DATE_EMISSION ASC, MOIS_DATE_EMISSION ASC");
                ListeResultatModel lrm = this.getListeResultat();
                MySqlDataResultSet mySqlDataResultSet = new MySqlDataResultSet(this.getElementModel(), this.getCollectivite(), this.getBudget(), "/n:DOC_PES_Facture/n:PESFacture/n:FactureIndiv", request.toString(), lrm, dl, this.getUser());
                return mySqlDataResultSet;
            }
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (con != null) {
                dl.releaseConnection(con);
            }
        }
        return DataLayerManager.getImplementation().getEmptyDataResultSet();
    }
}

