/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.plugins;

import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PluginModel;
import java.io.OutputStream;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExportPlugin {
    private Hashtable<String, String> params;
    private XemeliosUser user;
    private ElementModel elementModel;
    private Pair collectivite;
    private Pair budget;
    private Pair nomenclatureReference;
    private PluginModel model;
    private OutputStream os;
    private ProgressListener progressListener;

    public ExportPlugin(XemeliosUser user) {
        this.user = user;
    }

    public abstract Long doExport() throws Exception;

    public abstract void computeParameters() throws Exception;

    public void setElementModel(ElementModel em) {
        this.elementModel = em;
    }

    public ElementModel getElementModel() {
        return this.elementModel;
    }

    public void setCollectivite(Pair coll) {
        this.collectivite = coll;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setBudget(Pair budg) {
        this.budget = budg;
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void setNomenclatureReference(Pair nomencl) {
        this.nomenclatureReference = nomencl;
    }

    public Pair getNomenclatureReference() {
        return this.nomenclatureReference;
    }

    public EtatModel getEtatModel() {
        return this.elementModel.getParent();
    }

    public DocumentModel getDocumentModel() {
        return this.getEtatModel().getParent();
    }

    public void setPluginModel(PluginModel model) {
        this.model = model;
    }

    public PluginModel getPluginModel() {
        return this.model;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    public void setParameters(Hashtable<String, String> params) {
        this.params = params;
    }

    public Hashtable<String, String> getParameters() {
        return this.params;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public Pair getRefenrenceNomenclature() {
        return this.nomenclatureReference;
    }

    public void setRefenrenceNomenclature(Pair refenrenceNomenclature) {
        this.nomenclatureReference = refenrenceNomenclature;
    }

    public abstract String getDefaultFileExtension();

    public static interface ProgressListener {
        public void setProgressInfos(int var1, String var2);

        public void pushProgress();

        public void setProgressVisible(boolean var1);
    }
}

