/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.importers;

import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.PJRef;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.importers.ImportServiceProvider;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EtatImporteur
extends SwingWorker<String, String> {
    public static final transient String OVERWRITE_RULE_ALWAYS = "always";
    public static final transient String OVERWRITE_RULE_NEVER = "never";
    public static final transient String OVERWRITE_RULE_ASK = "ask";
    public static final transient String OVERWRITE_RULE_DEFAULT = "default";
    private static Logger logger = Logger.getLogger(EtatImporteur.class);
    protected DocumentModel dm;
    protected Pair col;
    protected Pair bdg;
    protected File[] filesToImport;
    protected PJRef[] pjs;
    protected Exception inProcessException = null;
    protected long start;
    private ImportServiceProvider impSvcProvider;
    protected XemeliosUser user;
    private FileInfo fileInfo = null;
    protected int warningCount = 0;
    protected String overwriteRule = "default";

    public String doInBackground() {
        block24: {
            block23: {
                this.fileInfo = new FileInfo();
                this.start = System.currentTimeMillis();
                this.getImpSvcProvider().displayProgress((this.filesToImport == null ? 0 : this.filesToImport.length) + (this.pjs == null ? 0 : this.pjs.length));
                try {
                    this.preProcess();
                    if (this.filesToImport == null) break block23;
                    for (int i = 0; i < this.filesToImport.length && !this.isCancelled(); ++i) {
                        try {
                            File f = this.filesToImport[i];
                            final String fName = f.getName();
                            try {
                                if (SwingUtilities.isEventDispatchThread()) {
                                    this.firePropertyChange("FILE_NAME", null, fName);
                                } else {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            EtatImporteur.this.firePropertyChange("FILE_NAME", null, fName);
                                        }
                                    });
                                }
                            }
                            catch (Throwable t) {
                                logger.fatal((Object)"in fireFileName:", t);
                            }
                            this.preImportFile(f);
                            this.fileInfo.merge(this.importFile(f));
                            this.postImportFile(f);
                            this.bdg = null;
                            this.col = null;
                            continue;
                        }
                        catch (Exception ex) {
                            this.inProcessException = ex;
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    this.inProcessException = ex;
                    ex.printStackTrace();
                }
            }
            try {
                this.postProcess(this.inProcessException != null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            if (!this.isCancelled()) {
                try {
                    DataImpl di = DataLayerManager.getImplementation();
                    if (this.pjs == null) break block24;
                    for (PJRef pj : this.pjs) {
                        if (this.isCancelled()) break;
                        final String fName = pj.getFileName();
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    EtatImporteur.this.firePropertyChange("FILE_NAME", null, fName);
                                }
                            });
                        }
                        catch (Throwable t) {
                            logger.fatal((Object)"in fireFileName:", t);
                        }
                        if (!pj.isValid()) continue;
                        di.importPj(pj, this.user);
                    }
                }
                catch (Exception ex) {
                    this.inProcessException = ex;
                    ex.printStackTrace();
                }
            }
        }
        StringBuffer msg = new StringBuffer();
        if (!this.isCancelled()) {
            msg.append("L'import des fichiers est termin\u00e9.\n");
            if (this.fileInfo.getGlobalCount() == 0L) {
                msg.append("Pas de donn\u00e9es import\u00e9es.");
            } else {
                try {
                    msg.append(this.fileInfo.toString(Loader.getDocumentsInfos(null)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                msg.append(this.getAdditionalMessage());
            }
        } else {
            msg.append("L'import des fichiers a \u00e9t\u00e9 interrompu.");
        }
        logger.info((Object)("\n" + msg));
        this.firePropertyChange("terminated", null, msg);
        return msg.toString();
    }

    protected void done() {
        super.done();
        if (this.inProcessException != null) {
            this.getImpSvcProvider().displayException(this.inProcessException);
        }
        String msg = "";
        try {
            msg = (String)this.get();
            if (this.warningCount > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n\nCertains \u00e9l\u00e9ments ont p\u00fb mal \u00eatre index\u00e9, en particulier");
                sb.append("\nsi certains champs \u00e9taient trop longs dans les fichiers");
                sb.append("\nque vous avez import\u00e9.");
                sb.append("\n").append(this.warningCount).append(" \u00e9l\u00e9ments sont concern\u00e9s, mais ils ont bien \u00e9t\u00e9");
                sb.append("\nimport\u00e9s et seront disponibles en recherche. Vous risquez");
                sb.append("\ncependant de ne pas les trouver en utilisant des crit\u00e8res");
                sb.append("\navec l'op\u00e9rateur \"finit par\".");
                msg = msg.concat(sb.toString());
            }
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
        }
        catch (ExecutionException eEx) {
            eEx.printStackTrace();
        }
        catch (CancellationException cEx) {
            msg = "Import annul\u00e9";
        }
        this.getImpSvcProvider().displayMessage(msg, 1);
    }

    public DocumentModel getDocumentModel() {
        return this.dm;
    }

    public void setDocument(DocumentModel dm) {
        this.dm = dm;
    }

    public void setDocument(DocumentModel dm, Pair collectivite, Pair budget) {
        this.dm = dm;
        this.bdg = budget;
        this.col = collectivite;
    }

    public abstract String getAdditionalMessage();

    public void setFilesToImport(Collection<File> fichiers) throws Exception {
        Object[] data = fichiers.toArray();
        this.filesToImport = new File[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.filesToImport[i] = (File)data[i];
        }
    }

    public void setFilesToImport(File[] fichiers) throws Exception {
        this.filesToImport = fichiers;
    }

    public File[] getFilesToImport() throws Exception {
        return this.filesToImport;
    }

    public void setPjs(Collection<PJRef> piecesJointes) throws Exception {
        Object[] data = piecesJointes.toArray();
        this.pjs = new PJRef[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.pjs[i] = (PJRef)data[i];
        }
    }

    protected void preProcess() throws Exception {
    }

    protected void postProcess(boolean isErrorOccured) throws Exception {
    }

    protected void preImportFile(File f) throws Exception {
    }

    protected void postImportFile(File f) throws Exception {
    }

    protected abstract FileInfo importFile(File var1) throws Exception;

    public ImportServiceProvider getImpSvcProvider() {
        return this.impSvcProvider;
    }

    public void setImpSvcProvider(ImportServiceProvider impSvcProvider) {
        this.impSvcProvider = impSvcProvider;
    }

    public XemeliosUser getUser() {
        return this.user;
    }

    public Pair getCollectivite() {
        return this.col;
    }

    public Pair getBudget() {
        return this.bdg;
    }

    public void setCollectivite(Pair p) {
        this.col = p;
    }

    public void setBudget(Pair p) {
        this.bdg = p;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setOverwriteRule(String rule) {
        this.overwriteRule = rule;
    }

    public String getOverwriteRule() {
        return this.overwriteRule;
    }
}

