/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.utils.jdbc;

import fr.gouv.finances.dgfip.xemelios.data.utils.jdbc.JdbcUtils;
import java.lang.reflect.Constructor;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;

public interface RowMapper {
    public Object map(ResultSet var1) throws SQLException;

    public static class BlobColToByteArrayRowMapper
    extends ColRowMapper {
        public BlobColToByteArrayRowMapper() {
        }

        public BlobColToByteArrayRowMapper(int colIndex) {
            super(colIndex);
        }

        public BlobColToByteArrayRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            Blob blob = this.getColIndex() != null ? rs.getBlob(this.getColIndex()) : rs.getBlob(this.getColName());
            return blob != null && blob.length() > 0L ? blob.getBytes(1L, (int)blob.length()) : null;
        }
    }

    public static class ClobColToStringRowMapper
    extends ColRowMapper {
        public ClobColToStringRowMapper() {
        }

        public ClobColToStringRowMapper(int colIndex) {
            super(colIndex);
        }

        public ClobColToStringRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            Clob clob = this.getColIndex() != null ? rs.getClob(this.getColIndex()) : rs.getClob(this.getColName());
            return clob != null && clob.length() > 0L ? clob.getSubString(1L, (int)clob.length()) : null;
        }
    }

    public static class ColToTimestampRowMapper
    extends ColRowMapper {
        public ColToTimestampRowMapper() {
        }

        public ColToTimestampRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToTimestampRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? rs.getTimestamp(this.getColIndex()) : rs.getTimestamp(this.getColName());
        }
    }

    public static class ColToTimeRowMapper
    extends ColRowMapper {
        public ColToTimeRowMapper() {
        }

        public ColToTimeRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToTimeRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? rs.getTime(this.getColIndex()) : rs.getTime(this.getColName());
        }
    }

    public static class ColToDateRowMapper
    extends ColRowMapper {
        public ColToDateRowMapper() {
        }

        public ColToDateRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToDateRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? rs.getDate(this.getColIndex()) : rs.getDate(this.getColName());
        }
    }

    public static class ColToBooleanRowMapper
    extends ColRowMapper {
        public ColToBooleanRowMapper() {
        }

        public ColToBooleanRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToBooleanRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? JdbcUtils.getBoolean(rs, this.getColIndex()) : JdbcUtils.getBoolean(rs, this.getColName());
        }
    }

    public static class ColToDoubleRowMapper
    extends ColRowMapper {
        public ColToDoubleRowMapper() {
        }

        public ColToDoubleRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToDoubleRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? JdbcUtils.getDouble(rs, this.getColIndex()) : JdbcUtils.getDouble(rs, this.getColName());
        }
    }

    public static class ColToFloatRowMapper
    extends ColRowMapper {
        public ColToFloatRowMapper() {
        }

        public ColToFloatRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToFloatRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? JdbcUtils.getFloat(rs, this.getColIndex()) : JdbcUtils.getFloat(rs, this.getColName());
        }
    }

    public static class ColToLongRowMapper
    extends ColRowMapper {
        public ColToLongRowMapper() {
        }

        public ColToLongRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToLongRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? JdbcUtils.getLong(rs, this.getColIndex()) : JdbcUtils.getLong(rs, this.getColName());
        }
    }

    public static class ColToIntegerRowMapper
    extends ColRowMapper {
        public ColToIntegerRowMapper() {
        }

        public ColToIntegerRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToIntegerRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? JdbcUtils.getInteger(rs, this.getColIndex()) : JdbcUtils.getInteger(rs, this.getColName());
        }
    }

    public static class ColToStringRowMapper
    extends ColRowMapper {
        public ColToStringRowMapper() {
        }

        public ColToStringRowMapper(int colIndex) {
            super(colIndex);
        }

        public ColToStringRowMapper(String colName) {
            super(colName);
        }

        public Object map(ResultSet rs) throws SQLException {
            return this.getColIndex() != null ? rs.getString(this.getColIndex()) : rs.getString(this.getColName());
        }
    }

    public static abstract class ColRowMapper
    implements RowMapper {
        private Integer colIndex;
        private String colName;

        public ColRowMapper() {
            this(1);
        }

        public ColRowMapper(int colIndex) {
            this.colIndex = new Integer(colIndex);
        }

        public ColRowMapper(String colName) {
            this.colName = colName;
        }

        public Integer getColIndex() {
            return this.colIndex;
        }

        public void setColIndex(Integer colIndex) {
            this.colIndex = colIndex;
            this.colName = null;
        }

        public String getColName() {
            return this.colName;
        }

        public void setColName(String colName) {
            this.colName = colName;
            this.colIndex = null;
        }
    }

    public static class ClassRowMapper
    implements RowMapper {
        private Class clazz;

        public ClassRowMapper(Class clazz) {
            this.clazz = clazz;
        }

        public Object map(ResultSet rs) throws SQLException {
            try {
                Constructor constructor = this.clazz.getConstructor(ResultSet.class);
                return constructor.newInstance(rs);
            }
            catch (Exception ex) {
                throw new RuntimeException("Erreur lors de la cr\u00e9ation d'une instance de la classe " + this.clazz, ex);
            }
        }
    }
}

