/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.utils.jdbc;

import fr.gouv.finances.dgfip.xemelios.data.utils.jdbc.ObjectHolder;
import fr.gouv.finances.dgfip.xemelios.data.utils.jdbc.PStmtBinder;
import fr.gouv.finances.dgfip.xemelios.data.utils.jdbc.RowHandler;
import fr.gouv.finances.dgfip.xemelios.data.utils.jdbc.RowMapper;
import fr.gouv.finances.dgfip.xemelios.data.utils.jdbc.UpdateResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcUtils {
    private static Logger logger = Logger.getLogger(JdbcUtils.class);

    public static Object queryObject(Connection connection, String sql, RowMapper rowMapper) throws SQLException {
        return JdbcUtils.queryObject(connection, sql, rowMapper, null);
    }

    public static Object queryObject(Connection connection, String sql, RowMapper rowMapper, PStmtBinder binder) throws SQLException {
        return JdbcUtils.queryObjectImpl(connection, sql, rowMapper, binder);
    }

    public static List queryObjects(Connection connection, String sql, RowMapper rowMapper) throws SQLException {
        return JdbcUtils.queryObjects(connection, sql, rowMapper, null);
    }

    public static List queryObjects(Connection connection, String sql, RowMapper rowMapper, PStmtBinder binder) throws SQLException {
        return JdbcUtils.queryObjectsImpl(connection, sql, rowMapper, binder);
    }

    public static void fetchSQL(Connection connection, String sql, RowHandler rowHandler) throws SQLException {
        JdbcUtils.fetchSQL(connection, sql, rowHandler, null);
    }

    public static void fetchSQL(Connection connection, String sql, RowHandler rowHandler, PStmtBinder binder) throws SQLException {
        JdbcUtils.fetchSQLImpl(connection, sql, rowHandler, binder);
    }

    public static UpdateResult executeUpdate(Connection connection, String sql) throws SQLException {
        return JdbcUtils.executeUpdate(connection, sql, null, null);
    }

    public static UpdateResult executeUpdate(Connection connection, String sql, PStmtBinder binder) throws SQLException {
        return JdbcUtils.executeUpdate(connection, sql, binder, null);
    }

    public static UpdateResult executeUpdate(Connection connection, String sql, String[] autoFields) throws SQLException {
        return JdbcUtils.executeUpdate(connection, sql, null, autoFields);
    }

    public static UpdateResult executeUpdate(Connection connection, String sql, PStmtBinder binder, String[] autoFields) throws SQLException {
        return JdbcUtils.executeUpdateImpl(connection, sql, binder, autoFields);
    }

    public static List<UpdateResult> executeUpdates(Connection connection, String sql, List<PStmtBinder> binders) throws SQLException {
        if (binders != null) {
            return JdbcUtils.executeUpdatesImpl(connection, sql, binders);
        }
        return Collections.emptyList();
    }

    public static Integer getInteger(ResultSet rs, String colName) throws SQLException {
        int res = rs.getInt(colName);
        return rs.wasNull() ? null : new Integer(res);
    }

    public static Integer getInteger(ResultSet rs, int colIndex) throws SQLException {
        int res = rs.getInt(colIndex);
        return rs.wasNull() ? null : new Integer(res);
    }

    public static Long getLong(ResultSet rs, String colName) throws SQLException {
        long res = rs.getLong(colName);
        return rs.wasNull() ? null : new Long(res);
    }

    public static Long getLong(ResultSet rs, int colIndex) throws SQLException {
        long res = rs.getLong(colIndex);
        return rs.wasNull() ? null : new Long(res);
    }

    public static Float getFloat(ResultSet rs, String colName) throws SQLException {
        float res = rs.getFloat(colName);
        return rs.wasNull() ? null : new Float(res);
    }

    public static Float getFloat(ResultSet rs, int colIndex) throws SQLException {
        float res = rs.getFloat(colIndex);
        return rs.wasNull() ? null : new Float(res);
    }

    public static Double getDouble(ResultSet rs, String colName) throws SQLException {
        double res = rs.getDouble(colName);
        return rs.wasNull() ? null : new Double(res);
    }

    public static Double getDouble(ResultSet rs, int colIndex) throws SQLException {
        double res = rs.getDouble(colIndex);
        return rs.wasNull() ? null : new Double(res);
    }

    public static Boolean getBoolean(ResultSet rs, String colName) throws SQLException {
        boolean res = rs.getBoolean(colName);
        return rs.wasNull() ? null : new Boolean(res);
    }

    public static Boolean getBoolean(ResultSet rs, int colIndex) throws SQLException {
        boolean res = rs.getBoolean(colIndex);
        return rs.wasNull() ? null : new Boolean(res);
    }

    public static void rollbackQuietly(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (Throwable throwable) {
                logger.error((Object)"Error during rollbackQuietly", throwable);
            }
        }
    }

    private static Object queryObjectImpl(Connection connection, String sql, final RowMapper rowMapper, PStmtBinder binder) throws SQLException {
        final ObjectHolder objectHolder = new ObjectHolder();
        RowHandler rowHandler = new RowHandler(){

            public boolean handleRow(ResultSet rs) throws SQLException {
                objectHolder.setObject(rowMapper.map(rs));
                return false;
            }
        };
        JdbcUtils.fetchSQL(connection, sql, rowHandler, binder);
        return objectHolder.getObject();
    }

    private static List queryObjectsImpl(Connection connection, String sql, final RowMapper rowMapper, PStmtBinder binder) throws SQLException {
        final ArrayList objectList = new ArrayList();
        RowHandler rowHandler = new RowHandler(){

            public boolean handleRow(ResultSet rs) throws SQLException {
                objectList.add(rowMapper.map(rs));
                return true;
            }
        };
        JdbcUtils.fetchSQL(connection, sql, rowHandler, binder);
        return objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchSQLImpl(Connection connection, String sql, RowHandler rowHandler, PStmtBinder binder) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        binder = binder != null ? binder : PStmtBinder.nullPStmtBinder;
        try {
            long start = System.currentTimeMillis();
            ps = connection.prepareStatement(sql);
            binder.bind(ps);
            rs = ps.executeQuery();
            JdbcUtils.debug(sql, binder, start);
            boolean continueFetching = true;
            while (continueFetching && rs.next()) {
                continueFetching = rowHandler.handleRow(rs);
            }
        }
        catch (SQLException sqle) {
            JdbcUtils.error(sql, binder, sqle);
            throw sqle;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private static List<UpdateResult> executeUpdatesImpl(Connection connection, String sql, List<PStmtBinder> binders) throws SQLException {
        boolean isLogged = false;
        PreparedStatement ps = null;
        try {
            long start = System.currentTimeMillis();
            ps = connection.prepareStatement(sql);
            for (PStmtBinder binder : binders) {
                binder.bind(ps);
                try {
                    ps.addBatch();
                }
                catch (SQLException sqle) {
                    JdbcUtils.error(sql, binder, sqle);
                    isLogged = true;
                    throw sqle;
                }
            }
            int[] toReturnAsInt = ps.executeBatch();
            ArrayList<UpdateResult> toReturn = new ArrayList<UpdateResult>(toReturnAsInt.length);
            JdbcUtils.debug(sql, binders, start);
            for (int i = 0; i < toReturnAsInt.length; ++i) {
                toReturn.add(new UpdateResult(toReturnAsInt[i], null));
            }
            ArrayList<UpdateResult> arrayList = toReturn;
            return arrayList;
        }
        catch (SQLException sqle) {
            if (!isLogged) {
                JdbcUtils.error(sql, binders, sqle);
            }
            throw sqle;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UpdateResult executeUpdateImpl(Connection connection, String sql, PStmtBinder binder, String[] autoFields) throws SQLException {
        PreparedStatement ps = null;
        ResultSet keyRs = null;
        binder = binder != null ? binder : PStmtBinder.nullPStmtBinder;
        try {
            long start = System.currentTimeMillis();
            ps = autoFields != null ? connection.prepareStatement(sql, autoFields) : connection.prepareStatement(sql);
            binder.bind(ps);
            int countUpdated = ps.executeUpdate();
            JdbcUtils.debug(sql, binder, start);
            ArrayList<Object> autoFieldResults = null;
            if (autoFields != null && autoFields.length > 0) {
                keyRs = ps.getGeneratedKeys();
                autoFieldResults = new ArrayList<Object>();
                while (keyRs.next()) {
                    autoFieldResults.add(keyRs.getObject(1));
                }
            } else {
                autoFieldResults = Collections.EMPTY_LIST;
            }
            UpdateResult updateResult = new UpdateResult(countUpdated, autoFieldResults.toArray());
            return updateResult;
        }
        catch (SQLException sqle) {
            JdbcUtils.error(sql, binder, sqle);
            throw sqle;
        }
        finally {
            try {
                if (keyRs != null) {
                    keyRs.close();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private static void error(String sql, PStmtBinder binder, SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        sb.append("Erreur SQL :\n");
        sb.append("\n-----------------------------------------------------------------------------------------------\n");
        sb.append("---------- Original SQL is :\n");
        sb.append(sql);
        sb.append("\n");
        sb.append("---------- Parameters are :\n");
        sb.append(binder.toLogableParametersString());
        sb.append("\n---------- Binded SQL is :\n");
        sb.append(binder.toLogableBindedString(sql));
        sb.append("\n");
        sb.append("-----------------------------------------------------------------------------------------------\n");
        logger.info((Object)sb.toString(), (Throwable)sqle);
    }

    private static void error(String sql, List<PStmtBinder> binders, SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        sb.append("Erreur SQL :\n");
        sb.append("\n-----------------------------------------------------------------------------------------------\n");
        sb.append("---------- Original SQL is :\n");
        sb.append(sql);
        sb.append("\n");
        Iterator<PStmtBinder> iterator = binders.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            PStmtBinder binder = iterator.next();
            sb.append("---------- Parameters " + i + " are :\n");
            sb.append(binder.toLogableParametersString());
            sb.append("\n");
            if (i > 10) {
                sb.append("skipping others...\n");
                break;
            }
            ++i;
        }
        sb.append("-----------------------------------------------------------------------------------------------\n");
        logger.info((Object)sb.toString(), (Throwable)sqle);
    }

    private static void debug(String sql, PStmtBinder binder, long startTime) {
        if (logger.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            StringBuffer sb = new StringBuffer();
            sb.append("\n-----------------------------------------------------------------------------------------------\n");
            sb.append("---------- Original SQL is :\n");
            sb.append(sql);
            sb.append("\n");
            sb.append("---------- Binded SQL is :\n");
            sb.append(binder.toLogableBindedString(sql));
            sb.append("\n");
            sb.append("---------- Duration (without fetching) : " + duration + " ms\n");
            sb.append("-----------------------------------------------------------------------------------------------\n");
            logger.debug((Object)sb.toString());
        }
    }

    private static void debug(String sql, List<PStmtBinder> binders, long startTime) {
        if (logger.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            StringBuffer sb = new StringBuffer();
            sb.append("\n-----------------------------------------------------------------------------------------------\n");
            sb.append("---------- SQL for batch is :\n");
            sb.append(sql);
            sb.append("\n");
            Iterator<PStmtBinder> iterator = binders.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                PStmtBinder binder = iterator.next();
                sb.append("---------- Parameters " + i + " are :\n");
                sb.append(binder.toLogableParametersString());
                sb.append("\n");
                if (i > 10) {
                    sb.append("skipping others...\n");
                    break;
                }
                ++i;
            }
            sb.append("---------- Duration : " + duration + " ms\n");
            sb.append("-----------------------------------------------------------------------------------------------\n");
            logger.debug((Object)sb.toString());
        }
    }
}

