/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.dgfip.xemelios.common.config.OptionModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ResourceRefModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SpecialKeyEntryModel;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(SelectModel.class);
    private NoeudModifiable _NMParent = null;
    private String configXPath = null;
    public static final transient String TAG = "select";
    public static final transient QName QN = new QName("select");
    public static final int SORT_NO = 0;
    public static final int SORT_KEY = 1;
    public static final int SORT_LIB = 2;
    private Vector<OptionModel> options = new Vector();
    private HashMap<String, OptionModel> hOptions = new HashMap();
    private String id;
    private String libelle;
    private String value;
    private Vector<RecherchePaireModel> recherches = new Vector();
    private HashMap<String, RecherchePaireModel> hRecherches = new HashMap();
    private Vector<SpecialKeyEntryModel> specialKeys = new Vector();
    private HashMap<String, SpecialKeyEntryModel> hSpecialKeys = new HashMap();
    private String sort = "no";
    private QName qn;
    private Vector<ResourceRefModel> resources = new Vector();

    public SelectModel(QName tagName) {
        this.qn = tagName;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (OptionModel.QN.equals(tagName)) {
            OptionModel om = (OptionModel)child;
            if (this.hOptions.containsKey(om.getValue())) {
                OptionModel old = this.hOptions.get(om.getValue());
                this.options.remove(old);
                this.hOptions.remove(old.getValue());
            }
            om.setParentAsNoeudModifiable(this);
            this.options.add(om);
            this.hOptions.put(om.getValue(), om);
        } else if (DocumentsMapping.RECHERCHE_PAIRE.equals(tagName)) {
            RecherchePaireModel rpm = (RecherchePaireModel)child;
            if (this.hRecherches.containsKey(rpm.getId())) {
                RecherchePaireModel old = this.hRecherches.get(rpm.getId());
                this.recherches.remove(old);
                this.hRecherches.remove(old.getId());
            }
            rpm.setParentAsNoeudModifiable(this);
            this.recherches.add(rpm);
            this.hRecherches.put(rpm.getId(), rpm);
        } else if (SpecialKeyEntryModel.QN.equals(tagName)) {
            SpecialKeyEntryModel skem = (SpecialKeyEntryModel)child;
            String key = String.valueOf(skem.getPos());
            if (this.hSpecialKeys.containsKey(key)) {
                SpecialKeyEntryModel old = this.hSpecialKeys.get(key);
                this.specialKeys.remove(old);
                this.hSpecialKeys.remove(key);
            }
            skem.setParentAsNoeudModifiable(this);
            this.specialKeys.add(skem);
            this.hSpecialKeys.put(key, skem);
        } else if (ResourceRefModel.QNAME.equals(tagName)) {
            this.resources.add((ResourceRefModel)child);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.libelle = attributes.getValue("libelle") != null ? attributes.getValue("libelle") : this.libelle;
        this.value = attributes.getValue("value") != null ? attributes.getValue("value") : this.value;
        this.sort = attributes.getValue("sort") != null ? attributes.getValue("sort") : this.sort;
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("sort", this.sort);
        if (this.libelle != null) {
            output.addAttribute("libelle", this.libelle);
        }
        for (OptionModel om : this.options) {
            om.marshall(output);
        }
        for (RecherchePaireModel rpm : this.recherches) {
            rpm.marshall(output);
        }
        for (ResourceRefModel rrm : this.resources) {
            rrm.marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("//select/@id is required");
        }
        for (OptionModel om : this.options) {
            om.validate();
        }
        for (RecherchePaireModel rpm : this.recherches) {
            rpm.validate();
        }
        for (SpecialKeyEntryModel spe : this.specialKeys) {
            spe.validate();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public Vector<OptionModel> getOptions() {
        return this.options;
    }

    public Vector<RecherchePaireModel> getRecherches() {
        return this.recherches;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SelectModel clone() {
        SelectModel sm = new SelectModel(QN);
        sm.id = this.id;
        sm.libelle = this.libelle;
        sm.value = this.value;
        sm.sort = this.sort;
        for (OptionModel om : this.options) {
            try {
                sm.addChild((XmlMarshallable)om.clone(), OptionModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().option", t);
            }
        }
        for (RecherchePaireModel rpm : this.recherches) {
            try {
                sm.addChild((XmlMarshallable)rpm.clone(), DocumentsMapping.RECHERCHE_PAIRE);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().recherche-paire", t);
            }
        }
        for (SpecialKeyEntryModel skem : this.specialKeys) {
            try {
                sm.addChild((XmlMarshallable)skem.clone(), SpecialKeyEntryModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().special-key-entry", t);
            }
        }
        for (ResourceRefModel rrm : this.resources) {
            try {
                sm.addChild(rrm.clone(), ResourceRefModel.QNAME);
            }
            catch (Throwable t) {}
        }
        return sm;
    }

    public int getSortBy() {
        if ("no".equals(this.sort)) {
            return 0;
        }
        if ("key".equals(this.sort)) {
            return 1;
        }
        return 2;
    }

    public Vector<SpecialKeyEntryModel> getSpecialKeys() {
        return this.specialKeys;
    }

    public Collection<Pair> getNewRecipient() {
        int sortBy = this.getSortBy();
        if (sortBy == 0) {
            return new Vector<Pair>();
        }
        Comparator cp = sortBy == 1 ? new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                return p1.key.compareTo(p2.key);
            }
        } : new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                return p1.libelle.compareTo(p2.libelle);
            }
        };
        return new TreeSet<Pair>(cp);
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00ef\u00bf\u00bd jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("option".equals(tagName)) {
            return this.hOptions.get(id);
        }
        if ("recherche-paire".equals(tagName)) {
            return this.hRecherches.get(id);
        }
        if ("special-key-entry".equals(tagName)) {
            return this.hSpecialKeys.get(id);
        }
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("option".equals(childTagName)) {
            return new String[]{"value"};
        }
        if ("recherche-paire".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("special-key-entry".equals(childTagName)) {
            return new String[]{"pos"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/select[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName qname = new QName(uri, localName);
        if (OptionModel.QN.equals(qname)) {
            return (XmlMarshallable)this.hOptions.get(atts.getValue("value"));
        }
        if (DocumentsMapping.RECHERCHE_PAIRE.equals(qname)) {
            return (XmlMarshallable)this.hRecherches.get(atts.getValue("id"));
        }
        if (SpecialKeyEntryModel.QN.equals(qname)) {
            return (XmlMarshallable)this.hSpecialKeys.get(atts.getValue("id"));
        }
        return null;
    }

    public boolean isDependantRepository() {
        boolean ret = false;
        if (this.recherches.size() > 0) {
            ret = true;
        }
        return ret;
    }

    public QName getQName() {
        return this.qn;
    }

    public Vector<ResourceRefModel> getResources() {
        return this.resources;
    }
}

