/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.common.config.RechercheModel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedRequestsModel
implements XmlMarshallable {
    private static final Logger logger = Logger.getLogger(SavedRequestsModel.class);
    public static final transient String TAG = "saved-requests";
    public static final transient QName QN = new QName("saved-requests");
    private String elementId;
    private String etatId;
    private String documentId;
    private Hashtable<String, RechercheModel> requests = new Hashtable();
    private boolean unavailable = false;

    public SavedRequestsModel(QName tagName, ElementModel em) {
        this(tagName);
        this.elementId = em.getId();
        this.etatId = em.getParent().getId();
        this.documentId = em.getParent().getParent().getId();
    }

    public SavedRequestsModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (RechercheModel.QN.equals(tagName)) {
            this.add((RechercheModel)child);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        block5: {
            this.elementId = attributes.getValue("element-id");
            if (this.elementId == null) {
                this.elementId = attributes.getValue("etat-id");
                try {
                    Vector<ElementModel> elements = Loader.getDocsInfos(null).getElementsById(this.elementId);
                    if (elements.size() > 0) {
                        this.etatId = elements.get(0).getParent().getId();
                        this.documentId = elements.get(0).getParent().getParent().getId();
                        break block5;
                    }
                    this.unavailable = true;
                }
                catch (Exception ex) {
                    logger.error((Object)"unexpected error at getAttributes(XmlAttributes)", (Throwable)ex);
                }
            } else {
                this.etatId = attributes.getValue("etat-id");
                this.documentId = attributes.getValue("document-id");
            }
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        if (this.unavailable) {
            return;
        }
        output.startTag(TAG);
        output.addAttribute("document-id", this.documentId);
        output.addAttribute("etat-id", this.etatId);
        output.addAttribute("element-id", this.elementId);
        Enumeration<RechercheModel> enumer = this.requests.elements();
        while (enumer.hasMoreElements()) {
            enumer.nextElement().marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public Object clone() {
        SavedRequestsModel srm = new SavedRequestsModel(QN);
        Enumeration<String> enumer = this.requests.keys();
        while (enumer.hasMoreElements()) {
            String key = enumer.nextElement();
            RechercheModel rm = this.requests.get(key);
            try {
                srm.addChild(rm, RechercheModel.QN);
            }
            catch (Throwable t) {
                logger.error((Object)"clone().recherche", t);
            }
        }
        srm.documentId = this.documentId;
        srm.etatId = this.etatId;
        srm.elementId = this.elementId;
        srm.unavailable = this.unavailable;
        return srm;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getEtatId() {
        return this.elementId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void add(RechercheModel rm) {
        if (this.requests.containsKey(rm.getName())) {
            this.requests.remove(rm.getName());
        }
        this.requests.put(rm.getName(), rm);
    }

    public void delete(RechercheModel rm) {
        this.requests.remove(rm.getName());
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public Collection<RechercheModel> getRecherches() {
        return this.requests.values();
    }

    String getKey() {
        return this.documentId + "|" + this.etatId + "|" + this.elementId;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return this.requests.get(atts.getValue("name"));
    }

    public QName getQName() {
        return QN;
    }

    public void setUnWritable(String name) {
        Enumeration<RechercheModel> enumer = this.requests.elements();
        while (enumer.hasMoreElements()) {
            enumer.nextElement().setUnWritable(name);
        }
    }
}

