/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PJRef {
    private String collectivite;
    private String pjName;
    private String tmpFileName;
    private ZipEntry ze;
    private String fileName;
    private long uncompressedSize;
    private boolean valid = true;
    private byte[] data;

    public boolean isValid() {
        return this.valid;
    }

    public PJRef(ZipEntry ze) {
        this.ze = ze;
        this.initialize();
    }

    public PJRef() {
    }

    private void initialize() {
        String entryName = this.ze.getName();
        String sTmp = entryName.substring("PJ/".length());
        int pos = sTmp.lastIndexOf(47);
        if (pos < 0) {
            this.valid = false;
            return;
        }
        this.collectivite = sTmp.substring(0, pos);
        this.fileName = sTmp.substring(pos + 1);
        pos = this.fileName.lastIndexOf(46);
        this.pjName = pos >= 0 ? this.fileName.substring(0, pos) : this.fileName;
        this.uncompressedSize = this.ze.getSize();
    }

    public File writeTmpFile(File tmpDir, ZipFile zf) throws IOException {
        File tmpFile = File.createTempFile("PJ-", "", tmpDir);
        FileOutputStream fos = new FileOutputStream(tmpFile);
        InputStream is = zf.getInputStream(this.ze);
        byte[] buffer = new byte[1024];
        int read = 0;
        do {
            if ((read = is.read(buffer)) < 0) continue;
            fos.write(buffer, 0, read);
        } while (read > 0);
        fos.flush();
        fos.close();
        this.tmpFileName = tmpFile.getPath();
        is.close();
        return tmpFile;
    }

    public InputStream getDataInputStream() throws IOException {
        if (this.tmpFileName != null) {
            return new FileInputStream(this.tmpFileName);
        }
        return new ByteArrayInputStream(this.data);
    }

    public String getCollectivite() {
        return this.collectivite;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPjName() {
        return this.pjName;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public static boolean isPJ(ZipEntry ze) {
        String name = ze.getName();
        return !ze.isDirectory() && name.startsWith("PJ/");
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.uncompressedSize = data.length;
    }

    public String getTmpFileName() {
        return this.tmpFileName;
    }

    public void setTmpFileName(String tmpFileName) {
        this.tmpFileName = tmpFileName;
    }

    public void setCollectivite(String collectivite) {
        this.collectivite = collectivite;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPjName(String pjName) {
        this.pjName = pjName;
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }
}

