/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.utils;

import java.text.ParseException;
import java.text.StringCharacterIterator;

public class StringUtilities {
    public static String removeFileNameSuffix(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null file name");
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public static String getFileNameSuffix(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            return fileName.substring(pos + 1);
        }
        return fileName;
    }

    public static String changeFileNameToClassName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null File Name");
        }
        String className = null;
        if (name.toLowerCase().endsWith(".class")) {
            className = name.replace('/', '.');
            className = className.replace('\\', '.');
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }

    public static int getClosingParenthesisPos(String source, int openningPos) throws ParseException {
        int current;
        int count = 0;
        int length = source.length();
        boolean found = false;
        for (current = openningPos; !found && current < length; ++current) {
            char c = source.charAt(current);
            if (c == '(') {
                ++count;
                continue;
            }
            if (c != ')' || --count != 0) continue;
            found = true;
        }
        if (!found) {
            throw new ParseException("closing ')' not found for openning '(' at " + openningPos, openningPos);
        }
        return current - 1;
    }

    public static String toAscii(String str, String unconvertibleCharReplacement) {
        StringBuffer ascii = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char c = iter.first();
        while (c != '\uffff') {
            if (c <= '\u007f') {
                ascii.append(c);
            } else if (c > '\u00ff') {
                ascii.append(unconvertibleCharReplacement);
            } else {
                String asciiCharString;
                switch (c) {
                    case '\u00a9': {
                        asciiCharString = "(c)";
                        break;
                    }
                    case '\u00ab': 
                    case '\u00bb': {
                        asciiCharString = "\"";
                        break;
                    }
                    case '\u00ae': {
                        asciiCharString = "(r)";
                        break;
                    }
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': {
                        asciiCharString = "A";
                        break;
                    }
                    case '\u00c6': {
                        asciiCharString = "AE";
                        break;
                    }
                    case '\u00c7': {
                        asciiCharString = "C";
                        break;
                    }
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': {
                        asciiCharString = "E";
                        break;
                    }
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': {
                        asciiCharString = "I";
                        break;
                    }
                    case '\u00d1': {
                        asciiCharString = "N";
                        break;
                    }
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': {
                        asciiCharString = "O";
                        break;
                    }
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': {
                        asciiCharString = "U";
                        break;
                    }
                    case '\u00dd': {
                        asciiCharString = "Y";
                        break;
                    }
                    case '\u00df': {
                        asciiCharString = "SS";
                        break;
                    }
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': 
                    case '\u00e5': {
                        asciiCharString = "a";
                        break;
                    }
                    case '\u00e6': {
                        asciiCharString = "ae";
                        break;
                    }
                    case '\u00e7': {
                        asciiCharString = "c";
                        break;
                    }
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': 
                    case '\u00eb': {
                        asciiCharString = "e";
                        break;
                    }
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': 
                    case '\u00ef': {
                        asciiCharString = "i";
                        break;
                    }
                    case '\u00f1': {
                        asciiCharString = "n";
                        break;
                    }
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': {
                        asciiCharString = "o";
                        break;
                    }
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': {
                        asciiCharString = "u";
                        break;
                    }
                    case '\u00fd': 
                    case '\u00ff': {
                        asciiCharString = "y";
                        break;
                    }
                    default: {
                        asciiCharString = unconvertibleCharReplacement;
                    }
                }
                ascii.append(asciiCharString);
            }
            c = iter.next();
        }
        return ascii.toString();
    }

    public static String pad(char model, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(model);
        }
        return sb.toString();
    }
}

