/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.utils;

import java.security.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    private static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy";
    private static final String DEFAULT_DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";

    public static Date parseDate(String dateAsString) throws ParseException {
        return DateUtils.parseDate(dateAsString, DEFAULT_DATE_FORMAT);
    }

    public static Date parseDate(String dateAsString, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(dateAsString);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatTime(Date date) {
        return DateUtils.formatDate(date, DEFAULT_TIME_FORMAT);
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String formatDate(Timestamp ts, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(ts);
    }

    public static Date truncDate(Date date) {
        return DateUtils.truncDate(date, DEFAULT_DATE_FORMAT);
    }

    public static Date truncDate(Date date, String format) {
        try {
            return DateUtils.parseDate(DateUtils.formatDate(date, format), format);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static Date addDay(Date date, int dayCount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, dayCount);
        return calendar.getTime();
    }

    public static Date subDay(Date date, int dayCount) {
        return DateUtils.addDay(date, -dayCount);
    }

    public static java.sql.Date toSqlDate(Date date) {
        return date != null ? new java.sql.Date(date.getTime()) : null;
    }

    public static String durationToString(Long ms) {
        if (ms == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (ms >= 31536000000L) {
            long years = ms / 31536000000L;
            ms = ms % 31536000000L;
            sb.append(years);
            sb.append(" An" + (years > 1L ? "s " : ""));
        }
        if (ms >= 86400000L) {
            long days = ms / 86400000L;
            ms = ms % 86400000L;
            sb.append(sb.length() > 0 ? " " : "");
            sb.append(days);
            sb.append(" Jour" + (days > 1L ? "s " : ""));
        }
        if (ms >= 3600000L) {
            long hours = ms / 3600000L;
            ms = ms % 3600000L;
            sb.append(sb.length() > 0 ? " " : "");
            sb.append(hours);
            sb.append(" Heure" + (hours > 1L ? "s " : ""));
        }
        if (ms >= 60000L) {
            long minutes = ms / 60000L;
            ms = ms % 60000L;
            sb.append(sb.length() > 0 ? " " : "");
            sb.append(minutes);
            sb.append(" Minute" + (minutes > 1L ? "s " : ""));
        }
        if (ms >= 1000L) {
            long secondes = ms / 1000L;
            ms = ms % 1000L;
            sb.append(sb.length() > 0 ? " " : "");
            sb.append(secondes);
            sb.append(" Seconde" + (secondes > 1L ? "s" : ""));
        }
        if (ms > 0L || sb.length() < 1) {
            sb.append(sb.length() > 0 ? " " : "");
            sb.append(ms + " ms");
        }
        return sb.toString();
    }

    private DateUtils() {
    }
}

