/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.controls.servicefait;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M108
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(M108.class);
    public static final transient String CTRL_ID = "CTL-M108";
    private Hashtable<String, Object> hParams;
    Vector<Anomalie> anomalies = new Vector();
    private static final String MSG_COMPTEUR = "#NOMBRE_SERVICE_FAIT#";
    private static final String MSG_ENTETE_IDAE = "#ENTETE_IDAE#";
    private static final String MSG_ENTETE_CODE_MVT = "#ENTETE_CODE_MVT#";
    private static final String MSG_ERREUR = "#ERREUR#";
    private String entete_codeMVT = "";
    private String entete_codeMVT_NodeId = "";
    private String entete_IdAE = "";
    private String ID_SERVICE_FAIT_Unique = "";
    private String generatedId = "";
    private Stack<StringBuffer> chars = new Stack();
    private int compteur = 0;
    private String numLigneTexte = "";
    private static final String CHEMIN_SERVICE_FAIT = "/SERVICE_FAIT/";
    private static final String CHEMIN_ENTETE = "/ENTETE/";
    private static final String CHEMIN_ENTETE_IDAE = "/ENTETE/ID_AE/";
    private static final String CHEMIN_CODE_MVT = "/ENTETE/CODE_MVT/";
    private static final String RETURN_ANOMALIES_PATH = "/SERVICE_FAIT/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In CTL-M108");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith("/SERVICE_FAIT/")) {
            this.anomalies.clear();
            this.generatedId = atts.getValue("added:generated-id");
            this.ID_SERVICE_FAIT_Unique = atts.getValue("ano:unique-id");
        }
        if (xpath.endsWith(CHEMIN_ENTETE)) {
            this.entete_codeMVT_NodeId = "";
            this.entete_codeMVT = "";
            this.entete_IdAE = "";
            ++this.compteur;
            this.numLigneTexte = atts.getValue("txt2xml:LineTxt") != null ? atts.getValue("txt2xml:LineTxt") : "";
        }
        if (xpath.endsWith(CHEMIN_CODE_MVT)) {
            this.entete_codeMVT_NodeId = atts.getValue("ano:node-id");
        }
        this.chars.push(new StringBuffer());
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        String erreur = "";
        if (xpath.endsWith(CHEMIN_ENTETE_IDAE)) {
            this.entete_IdAE = this.chars.peek().toString();
        }
        if (xpath.endsWith(CHEMIN_CODE_MVT)) {
            this.entete_codeMVT = this.chars.peek().toString();
        }
        if (xpath.endsWith(CHEMIN_ENTETE)) {
            if (!this.entete_codeMVT.equals("101") && !this.entete_codeMVT.equals("103")) {
                String msg = this.numLigneTexte.length() > 0 ? "Ligne n\u00b0" + this.numLigneTexte + " : " : "";
                msg = msg + this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_COMPTEUR, String.valueOf(this.compteur));
                msg = msg.replaceAll(MSG_ENTETE_IDAE, this.entete_IdAE);
                msg = msg.replaceAll(MSG_ENTETE_CODE_MVT, this.entete_codeMVT);
                String path = "@ano:unique-id='" + this.ID_SERVICE_FAIT_Unique + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Entete " + this.entete_IdAE;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("anoId", anoId);
                xslParams.put("presentation", "src");
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), "FEN0072A", "SERVICE_FAIT", this.entete_IdAE, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.entete_codeMVT_NodeId));
                this.anomalies.add(ano);
            }
            this.chars.pop();
            return null;
        }
        if (xpath.endsWith("/SERVICE_FAIT/")) {
            this.chars.pop();
            return this.anomalies;
        }
        this.chars.pop();
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
        this.chars.peek().append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

