/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.tie;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIE01
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(TIE01.class);
    public static final transient String CTRL_ID = "TIE01";
    private Vector<Anomalie> anos = null;
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String ligne_nodeId = null;
    private String tiers_nodeId = null;
    private static final String ON_RETURN_ANOMALIES = "Piece";
    private static final String FIN_LIGNE_PIECE = "LigneDePiece";
    private boolean depense = false;
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_typPce = "";
    private String ligne_IdLigne = "";
    private String tiers_nom = "";
    private String tiers_prenom = "";
    private String tiers_civilite = "";
    private String tiers_catTiers = "";
    private String addr_typAdr = "";
    private String addr_adr2 = "";
    private String addr_CP = "";
    private String addr_ville = "";
    private boolean infoTiersExists = false;
    private boolean adresseExists = false;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
    private static final String RECETTE = "PES_RecetteAller";
    private static final String DEPENSE = "PES_DepenseAller";
    private static final String CHEMIN_PIECE = "/Bordereau/Piece/";
    private static String CHEMIN_BLOCPIECE = "";
    private static String CHEMIN_BLOCPIECE_IDPCE = "";
    private static String CHEMIN_BLOCPIECE_TYPPCE = "";
    private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String R_CHEMIN_BLOCPIECE_TYPPCE = "/Bordereau/Piece/BlocPiece/TypPce/";
    private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static final String D_CHEMIN_BLOCPIECE_TYPPCE = "/Bordereau/Piece/BlocPiece/InfoPce/TypPce/";
    private static String CHEMIN_INFOLIGNEPIECE = "";
    private static String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "";
    private static final String R_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String R_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String D_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
    private static final String D_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
    private static final String CHEMIN_INFOTIERS = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/";
    private static final String CHEMIN_INFOTIERS_NOM = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Nom/";
    private static final String CHEMIN_INFOTIERS_PRENOM = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Prenom/";
    private static final String CHEMIN_INFOTIERS_CIVILITE = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Civilite/";
    private static final String CHEMIN_INFOTIERS_CATTIERS = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/CatTiers/";
    private static final String CHEMIN_ADRESSE = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/";
    private static final String CHEMIN_ADRESSE_TYPADR = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/TypAdr/";
    private static final String CHEMIN_ADRESSE_ADR2 = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/Adr2/";
    private static final String CHEMIN_ADRESSE_CP = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CP/";
    private static final String CHEMIN_ADRESSE_VILLE = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/Ville/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In TIE01");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.indexOf(DEPENSE) != -1) {
            this.depense = true;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_BLOCPIECE_TYPPCE = D_CHEMIN_BLOCPIECE_TYPPCE;
            CHEMIN_INFOLIGNEPIECE = D_CHEMIN_INFOLIGNEPIECE;
            CHEMIN_INFOLIGNEPIECE_IDLIGNE = D_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
        }
        if (xpath.indexOf(RECETTE) != -1) {
            this.depense = false;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_BLOCPIECE_TYPPCE = R_CHEMIN_BLOCPIECE_TYPPCE;
            CHEMIN_INFOLIGNEPIECE = R_CHEMIN_INFOLIGNEPIECE;
            CHEMIN_INFOLIGNEPIECE_IDLIGNE = R_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.ligne_nodeId = "";
            this.piece_IdPce = "";
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPCE)) {
            this.piece_typPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
            this.ligne_IdLigne = "";
            this.ligne_nodeId = atts.getValue("ano:node-id");
            this.tiers_nodeId = null;
            this.adresseExists = false;
            this.infoTiersExists = false;
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOTIERS)) {
            this.infoTiersExists = true;
            this.tiers_catTiers = "";
            this.tiers_civilite = "";
            this.tiers_prenom = "";
            this.tiers_nom = "";
            this.tiers_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOTIERS_NOM)) {
            this.tiers_nom = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOTIERS_PRENOM)) {
            this.tiers_prenom = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOTIERS_CIVILITE)) {
            this.tiers_civilite = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOTIERS_CATTIERS)) {
            this.tiers_catTiers = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE)) {
            this.adresseExists = true;
            this.addr_ville = "";
            this.addr_CP = "";
            this.addr_adr2 = "";
            this.addr_typAdr = "";
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_TYPADR)) {
            this.addr_typAdr = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_ADR2)) {
            this.addr_adr2 = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_CP)) {
            this.addr_CP = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_VILLE)) {
            this.addr_ville = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (ON_RETURN_ANOMALIES.equals(localName)) {
            return this.anos;
        }
        if (FIN_LIGNE_PIECE.equals(localName)) {
            boolean err = false;
            if (this.depense || !this.depense && !"06".equals(this.piece_typPce) && !"07".equals(this.piece_typPce) && !"14".equals(this.piece_typPce)) {
                if (!this.infoTiersExists) {
                    err = true;
                } else if (!"1".equals(this.addr_typAdr) && !"2".equals(this.addr_typAdr)) {
                    err = true;
                } else if ("".equals(this.tiers_nom)) {
                    err = true;
                } else if (!this.adresseExists) {
                    err = true;
                } else if ("".equals(this.addr_adr2) || "".equals(this.addr_CP) || "".equals(this.addr_ville)) {
                    err = true;
                } else if ("01".equals(this.tiers_catTiers) && ("".equals(this.tiers_prenom) || "".equals(this.tiers_civilite))) {
                    err = true;
                } else if (!("01".equals(this.tiers_catTiers) || "".equals(this.tiers_prenom) && "".equals(this.tiers_civilite))) {
                    err = true;
                }
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                msg = this.depense ? msg.replaceAll("#MT#", "Mandat") : msg.replaceAll("#MT#", "Titre");
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], this.depense ? "BordereauDepense" : "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.tiers_nodeId != null ? this.tiers_nodeId : this.ligne_nodeId));
                this.anos.add(ano);
            }
            return null;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

