/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC22
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC22.class);
    public static final transient String CTRL_ID = "REC22";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String bord_nodeId = null;
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String FIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String ligne_IdLigne = "";
    private String ligne_CodProdLoc = "";
    private String ligne_CodProdLoc_NodeId = "";
    private String ligne_IdLigne_NodeId = "";
    private boolean codProdLoc_isPresent = false;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String MSG_ERREUR = "#MSG_ERREUR#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String CHEMIN_INFOLIGNEPIECE_CODPRODLOC = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CodProdLoc/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC22");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_IdPce = "";
            if (!this.anos.isEmpty()) {
                this.anos = new Vector();
            }
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/")) {
            this.codProdLoc_isPresent = false;
            this.ligne_CodProdLoc = "";
            this.ligne_IdLigne = "";
            this.ligne_IdLigne_NodeId = "";
            this.ligne_CodProdLoc_NodeId = "";
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
            this.ligne_IdLigne_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_CODPRODLOC)) {
            this.codProdLoc_isPresent = true;
            this.ligne_CodProdLoc = atts.getValue("V");
            this.ligne_CodProdLoc_NodeId = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/")) {
            String msg;
            String severity;
            if (this.haveToTest() && (this.ligne_CodProdLoc.equals("") || this.ligne_CodProdLoc.equals("300") || this.ligne_CodProdLoc.equals("0") || this.ligne_CodProdLoc.equals("00") || this.ligne_CodProdLoc.equals("000") || this.ligne_CodProdLoc.equals("0000"))) {
                severity = this.getDocumentModel().getControlById(CTRL_ID).getSeverity();
                if (this.ligne_CodProdLoc.equals("300")) {
                    severity = "NON BLOQUANT";
                }
                msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                String message = msg = msg.replaceAll(MSG_ERREUR, "Code produit : [NON RENSEIGNE] ou renseign\u00e9 \u00e0 Divers");
                if (this.ligne_CodProdLoc.equals("300")) {
                    message = msg + " (NON BLOQUANT)";
                }
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, message, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), severity, path, xslParams);
                if (this.ligne_CodProdLoc.equals("")) {
                    ano.addNode(new Node(this.ligne_IdLigne_NodeId));
                } else {
                    ano.addNode(new Node(this.ligne_CodProdLoc_NodeId));
                }
                this.anos.add(ano);
            }
            if ("M21".equals((String)this.hParams.get("nomencl")) && this.codProdLoc_isPresent) {
                severity = this.getDocumentModel().getControlById(CTRL_ID).getSeverity();
                msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                msg = msg.replaceAll(MSG_ERREUR, "En M21, les codes produits hospitaliers ne sont pas valoris\u00e9s au niveau des Tiers mais au niveau des pi\u00e8ces comptables");
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), severity, path, xslParams);
                if (this.ligne_CodProdLoc.equals("")) {
                    ano.addNode(new Node(this.ligne_IdLigne_NodeId));
                } else {
                    ano.addNode(new Node(this.ligne_CodProdLoc_NodeId));
                }
                this.anos.add(ano);
            }
            return null;
        }
        if (xpath.endsWith(FIN_PIECE)) {
            return this.anos;
        }
        return null;
    }

    private boolean haveToTest() {
        String tmp = (String)this.hParams.get("nomencl");
        return "M4".equals(tmp) || "M14".equals(tmp) || "M52".equals(tmp) || "M61".equals(tmp) || "M71".equals(tmp);
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

