/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC17
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC17.class);
    public static final transient String CTRL_ID = "REC17";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private Vector<Node> nodesHasTVA = new Vector();
    private Vector<Node> nodesHasNoTVA = new Vector();
    private String docId = null;
    private String bord_nodeId = null;
    private String piece_nodeId = null;
    private static final String BLOQUANT = "BLOQUANT";
    private static final String NON_BLOQUANT = "NON BLOQUANT";
    private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/";
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String FIN_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
    private static final String FIN_INFO_LIGNE_PIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String ligne_IdLigne = "";
    private String piece_CodServ = "";
    private String piece_typPce = "";
    private String piece_natPce = "";
    private boolean allLinesHasTVAFilled = true;
    private boolean lineHasTVA = false;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_BLOCPIECE_CODSERV = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/CodServ/";
    private static final String CHEMIN_BLOCPIECE_TYPPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
    private static final String CHEMIN_BLOCPIECE_NATPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/NatPce/";
    private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String CHEMIN_INFOLIGNEPIECE_MTTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC17");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_typPce = "";
            this.piece_natPce = "";
            this.piece_CodServ = "";
            this.piece_IdPce = "";
            this.lineHasTVA = false;
            this.allLinesHasTVAFilled = true;
            this.nodesHasNoTVA.clear();
            this.nodesHasTVA.clear();
            this.piece_nodeId = atts.getValue("ano:node-id");
            this.anos.clear();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_CODSERV)) {
            this.piece_CodServ = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_NATPCE)) {
            this.piece_natPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPCE)) {
            this.piece_typPce = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/")) {
            this.ligne_IdLigne = "";
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTTVA)) {
            String ligne_Mttva = atts.getValue("V");
            if (ligne_Mttva != null && !"".equals(ligne_Mttva)) {
                this.lineHasTVA = true;
                this.nodesHasTVA.add(new Node(atts.getValue("ano:node-id")));
            } else {
                this.lineHasTVA = false;
                this.nodesHasNoTVA.add(new Node(atts.getValue("ano:node-id")));
            }
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/")) {
            this.allLinesHasTVAFilled &= this.lineHasTVA;
            return null;
        }
        if (xpath.endsWith(FIN_PIECE)) {
            if ("03".equals(this.piece_typPce) || "04".equals(this.piece_typPce) || "14".equals(this.piece_typPce) || "04".equals(this.piece_natPce)) {
                return null;
            }
            String severity = BLOQUANT;
            boolean err = false;
            Vector<Object> anonodes = new Vector();
            try {
                String[] servTVA = (String[])this.hParams.get("servTVA");
                boolean coltva = (Boolean)this.hParams.get("coltva");
                if (this.piece_CodServ != null && !"".equals(this.piece_CodServ)) {
                    severity = BLOQUANT;
                    if (this.contains(servTVA, this.piece_CodServ)) {
                        err = !this.allLinesHasTVAFilled;
                        anonodes = this.nodesHasNoTVA;
                    } else {
                        err = this.allLinesHasTVAFilled;
                        anonodes = this.nodesHasTVA;
                    }
                } else {
                    severity = NON_BLOQUANT;
                    if (coltva) {
                        err = !this.allLinesHasTVAFilled;
                        anonodes = this.nodesHasNoTVA;
                    } else {
                        err = this.allLinesHasTVAFilled;
                        anonodes = this.nodesHasTVA;
                    }
                }
            }
            catch (Exception e) {
                err = true;
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), severity, path, xslParams);
                ano.addAll(anonodes);
                this.anos.add(ano);
                return this.anos;
            }
            return null;
        }
        return null;
    }

    private boolean contains(String[] tab, String val) {
        for (String el : tab) {
            if (!el.equals(val)) continue;
            return true;
        }
        return false;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

