/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC07
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC07.class);
    public static final transient String CTRL_ID = "REC07";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String nodeId = null;
    private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private static final String FIN_INFOPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/";
    private String bord_IdBord = "";
    private String bord_ExerBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_NodeIdPce = "";
    private Hashtable<String, Vector<String>> pieces = new Hashtable();
    private Vector<Node> anonodes = new Vector();
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC07");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.anos = new Vector();
            this.piece_NodeIdPce = "";
            this.piece_IdPce = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
            this.piece_IdPce = atts.getValue("V");
            this.piece_NodeIdPce = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(FIN_INFOPCE)) {
            String clef = this.bord_ExerBord + "|" + this.bord_TypBord + "|" + this.piece_IdPce;
            Vector<String> tmp = this.pieces.get(clef);
            if (tmp == null) {
                tmp = new Vector();
                this.pieces.put(clef, tmp);
            }
            tmp.add(this.bord_IdBord + "|" + this.piece_NodeIdPce + "|0");
            return null;
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/")) {
            Enumeration<String> e = this.pieces.keys();
            while (e.hasMoreElements()) {
                String clef = e.nextElement();
                Vector<String> v = this.pieces.get(clef);
                if (v.size() <= 1) continue;
                StringTokenizer st = new StringTokenizer(clef, "|");
                String _bord_ExerBord = st.nextToken();
                String _bord_TypBord = st.nextToken();
                String _idPce = st.nextToken();
                String msgRef = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                StringBuffer msg = new StringBuffer();
                msg.append("<ul>");
                Vector<Node> anonodesid = new Vector<Node>();
                int i = 0;
                for (String clef2 : v) {
                    StringTokenizer st2 = new StringTokenizer(clef2, "|");
                    String _bord_IdBord = st2.nextToken();
                    String _piece_NodeIdPce = st2.nextToken();
                    String anoCree = st2.nextToken();
                    msg.append("<li>").append(msgRef.replaceAll(MSG_BORD_EXER, _bord_ExerBord).replaceAll(MSG_BORD_NUM, _bord_IdBord).replaceAll(MSG_BORD_TYPE, _bord_TypBord).replaceAll(MSG_PIECE_ID, _idPce)).append("</li>");
                    anonodesid.add(new Node(_piece_NodeIdPce));
                    if (i > 0 && "0".equals(anoCree)) {
                        msg.append("</ul>");
                        String path = "@added:primary-key='" + _bord_ExerBord + "-" + _bord_TypBord + "-" + _bord_IdBord + "'";
                        String anoId = IdGenerator.nextId();
                        String libelleLien = "Bordereau " + _bord_IdBord + " Mandat " + _idPce;
                        Hashtable<String, String> xslParams = new Hashtable<String, String>();
                        xslParams.put("elementId", "Bordereau");
                        xslParams.put("browser-destination", "internal");
                        xslParams.put("anoId", anoId);
                        Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", _bord_IdBord, localName, libelleLien, msg.toString(), this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                        ano.addAll(anonodesid);
                        this.anos.add(ano);
                        String tmp = _bord_IdBord + "|" + _piece_NodeIdPce + "|1";
                        v.remove(clef2);
                        v.add(tmp);
                    }
                    ++i;
                }
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }

    private class Quadruplet {
        private String exercice;
        private String typbordereau;
        private String idbordereau;
        private String idPiece;

        private Quadruplet(String exercice, String typbordereau, String idbordereau, String idPiece) {
            this.exercice = exercice;
            this.typbordereau = typbordereau;
            this.idbordereau = idbordereau;
            this.idPiece = idPiece;
        }
    }
}

