/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEP18
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(DEP18.class);
    public static final transient String CTRL_ID = "DEP18";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String nodeId = null;
    private static final String FIN_PIECE = "/PES_DepenseAller/Bordereau/Piece/";
    private static final String LIGNEPCE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/Piece/";
    private String bord_IdBord = "";
    private String bord_ExerBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_TypPce = "";
    private String piece_NodeIdPce = "";
    private String lignepiece_Id = "";
    private String lignepiece_TypPce_NodeId = "";
    private String lignepiece_CpteTiers_NodeId = "";
    private String node_id_id_actif = "";
    private boolean idActifExist = false;
    private boolean cpteTiersExist = false;
    private Vector<Triplet> vCpteTiersNodeId = new Vector();
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
    private static final String MSG_LIGNEPIECE_ID = "#LIGNE_IDLIGNE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_PIECE = "/PES_DepenseAller/Bordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/TypPce/";
    private static final String CHEMIN_BLOCLIGNEPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
    private static final String CHEMIN_BLOCLIGNEPIECE_ID = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
    private static final String CHEMIN_BLOCLIGNEPIECE_CPTETIERS = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/CpteTiers/";
    private static final String CHEMIN_BLOCLIGNEPIECE_IDACTIF = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/LiensIdent/IdActif/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In DEP18");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
            this.piece_IdPce = atts.getValue("V");
            this.anos.clear();
        }
        if (xpath.endsWith(CHEMIN_BLOCLIGNEPIECE)) {
            this.node_id_id_actif = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_IDACTIF)) {
            this.idActifExist = true;
            this.node_id_id_actif = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_CPTETIERS)) {
            this.cpteTiersExist = true;
            this.lignepiece_CpteTiers_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
            this.piece_TypPce = atts.getValue("V");
            this.lignepiece_TypPce_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_ID)) {
            this.lignepiece_Id = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(LIGNEPCE)) {
            if (this.piece_TypPce.equals("04") && this.idActifExist && !this.cpteTiersExist) {
                this.vCpteTiersNodeId.add(new Triplet(this.lignepiece_Id, this.lignepiece_TypPce_NodeId, this.node_id_id_actif));
            }
            this.idActifExist = false;
            this.cpteTiersExist = false;
            this.lignepiece_CpteTiers_NodeId = "";
            return null;
        }
        if (xpath.endsWith("/PES_DepenseAller/Bordereau/Piece/")) {
            if (this.vCpteTiersNodeId.size() > 0) {
                for (Triplet triplet : this.vCpteTiersNodeId) {
                    String nodeid_typepce = triplet.nodeid_typePce;
                    String ligneId = triplet.idLigne;
                    String nodeid_idactif = triplet.nodeid_idactif;
                    String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                    msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                    msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                    msg = msg.replaceAll(MSG_BORD_TYPE, this.bord_TypBord);
                    msg = msg.replaceAll(MSG_PIECE_ID, this.piece_IdPce);
                    msg = msg.replaceAll(MSG_LIGNEPIECE_ID, ligneId);
                    String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                    String anoId = IdGenerator.nextId();
                    String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                    Hashtable<String, String> xslParams = new Hashtable<String, String>();
                    xslParams.put("elementId", "");
                    xslParams.put("mandatId", this.piece_IdPce);
                    xslParams.put("browser-destination", "internal");
                    xslParams.put("anoId", anoId);
                    Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauDepense", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                    ano.addNode(new Node(nodeid_typepce));
                    ano.addNode(new Node(nodeid_idactif));
                    this.anos.add(ano);
                }
            }
            this.vCpteTiersNodeId.clear();
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }

    private class Triplet {
        private String idLigne;
        private String nodeid_typePce;
        private String nodeid_idactif;

        private Triplet(String id, String nodeidtyppce, String nodeididactif) {
            this.idLigne = id;
            this.nodeid_typePce = nodeidtyppce;
            this.nodeid_idactif = nodeididactif;
        }
    }
}

