/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEP03
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(DEP03.class);
    public static final transient String CTRL_ID = "DEP03";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private ArrayList<Node> nodesId = new ArrayList();
    private static final String FIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
    private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/";
    private String bord_ExerBord;
    private String bord_IdBord;
    private String bord_TypBord;
    private BigDecimal bord_MtBordHT;
    private BigDecimal bord_MtBordTVA;
    private BigDecimal bord_NodeIdBord;
    private static final String KEY_HASHTABLE_MT_HT = "MTBORDHT";
    private static final String KEY_HASHTABLE_MT_TVA = "MTBORDTVA";
    private static final String BALISE_MT_HT_PIECE = "MtHT";
    private static final String BALISE_MT_TVA_PIECE = "MtTVA";
    private static boolean CTRL_TVA = false;
    private static DecimalFormat df;
    private Hashtable<String, BigDecimal> hashMtsBord = new Hashtable();
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPEBORD = "#BORD_TYPE#";
    private static final String MSG_BORD_MTHT = "#BORD_MT_HT#";
    private static final String MSG_BORD_SOMMEHTPIECE = "#BORD_SOMME_HT_PIECE#";
    private static final String MSG_BORD_MTTVA = "#BORD_MT_TVA#";
    private static final String MSG_BORD_SOMMETVAPIECE = "#BORD_SOMME_TVA_PIECE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCBORDEREAU_MTHTBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/MtBordHT/";
    private static final String CHEMIN_BLOCBORDEREAU_MTHTPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/MtHT/";
    private static final String CHEMIN_BLOCBORDEREAU_MTTVABORD = "/PES_DepenseAller/Bordereau/BlocBordereau/MtBordTVA/";
    private static final String CHEMIN_BLOCBORDEREAU_MTTVAPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/MtTVA/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In DEP03");
        df = new DecimalFormat("############0.00");
        if (Boolean.parseBoolean(this.hParams.get("coltva").toString())) {
            CTRL_TVA = true;
        }
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        BigDecimal value;
        BigDecimal newValue;
        BigDecimal oldValue;
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTHTBORD) || xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTHTPIECE) || xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTTVABORD) || xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTTVAPIECE)) {
            this.nodesId.add(new Node(atts.getValue("ano:node-id")));
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTHTBORD)) {
            try {
                this.bord_MtBordHT = new BigDecimal(atts.getValue("V"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTTVABORD)) {
            try {
                this.bord_MtBordTVA = new BigDecimal(atts.getValue("V"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTHTPIECE)) {
            if (this.hashMtsBord.get(BALISE_MT_HT_PIECE) != null) {
                try {
                    oldValue = this.hashMtsBord.get(BALISE_MT_HT_PIECE);
                    newValue = new BigDecimal(atts.getValue("V")).add(oldValue);
                    this.hashMtsBord.put(BALISE_MT_HT_PIECE, newValue);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.debug((Object)"Pb de parsing de float dans DEP03.");
                }
            } else {
                value = new BigDecimal(atts.getValue("V"));
                this.hashMtsBord.put(BALISE_MT_HT_PIECE, value);
            }
        }
        if (CTRL_TVA && xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTTVAPIECE)) {
            if (this.hashMtsBord.get(BALISE_MT_TVA_PIECE) != null) {
                try {
                    oldValue = this.hashMtsBord.get(BALISE_MT_TVA_PIECE);
                    newValue = new BigDecimal(atts.getValue("V")).add(oldValue);
                    this.hashMtsBord.put(BALISE_MT_TVA_PIECE, newValue);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.debug((Object)"Pb de parsing de float dans DEP03.");
                }
            } else {
                value = new BigDecimal(atts.getValue("V"));
                this.hashMtsBord.put(BALISE_MT_TVA_PIECE, value);
            }
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("/PES_DepenseAller/Bordereau/")) {
            if (CTRL_TVA) {
                if (this.hashMtsBord.get(BALISE_MT_TVA_PIECE) != null && this.bord_MtBordHT != null && this.bord_MtBordTVA != null && this.hashMtsBord.get(BALISE_MT_HT_PIECE) != null) {
                    if (!this.hashMtsBord.get(BALISE_MT_HT_PIECE).equals(this.bord_MtBordHT) || !this.hashMtsBord.get(BALISE_MT_TVA_PIECE).equals(this.bord_MtBordTVA)) {
                        String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                        msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                        msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                        msg = msg.replaceAll(MSG_BORD_TYPEBORD, this.bord_TypBord);
                        msg = msg.replaceAll(MSG_BORD_MTHT, this.bord_MtBordHT != null ? this.bord_MtBordHT.toString() : "");
                        msg = msg.replaceAll(MSG_BORD_MTTVA, this.bord_MtBordTVA != null ? this.bord_MtBordTVA.toString() : "");
                        msg = msg.replaceAll(MSG_BORD_SOMMEHTPIECE, this.hashMtsBord.get(BALISE_MT_HT_PIECE).toString());
                        msg = msg.replaceAll(MSG_BORD_SOMMETVAPIECE, this.hashMtsBord.get(BALISE_MT_TVA_PIECE).toString());
                        String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                        String anoId = IdGenerator.nextId();
                        String libelleLien = "Bordereau " + this.bord_IdBord;
                        Hashtable<String, String> xslParams = new Hashtable<String, String>();
                        xslParams.put("elementId", "Bordereau");
                        xslParams.put("browser-destination", "internal");
                        xslParams.put("anoId", anoId);
                        Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauDepense", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                        ano.addAll(this.nodesId);
                        this.anos.add(ano);
                    }
                } else if (!this.hashMtsBord.get(BALISE_MT_HT_PIECE).equals(this.bord_MtBordHT)) {
                    String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                    msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                    msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                    msg = msg.replaceAll(MSG_BORD_TYPEBORD, this.bord_TypBord);
                    msg = msg.replaceAll(MSG_BORD_MTHT, this.bord_MtBordHT != null ? this.bord_MtBordHT.toString() : "");
                    msg = msg.replaceAll(MSG_BORD_MTTVA, this.bord_MtBordTVA != null ? this.bord_MtBordTVA.toString() : "");
                    msg = msg.replaceAll(MSG_BORD_SOMMEHTPIECE, this.hashMtsBord.get(BALISE_MT_HT_PIECE).toString());
                    msg = msg.replaceAll(MSG_BORD_SOMMETVAPIECE, "");
                    String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                    String anoId = IdGenerator.nextId();
                    String libelleLien = "Bordereau " + this.bord_IdBord;
                    Hashtable<String, String> xslParams = new Hashtable<String, String>();
                    xslParams.put("elementId", "Bordereau");
                    xslParams.put("browser-destination", "internal");
                    xslParams.put("anoId", anoId);
                    Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauDepense", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                    ano.addAll(this.nodesId);
                    this.anos.add(ano);
                }
            } else if (!this.hashMtsBord.get(BALISE_MT_HT_PIECE).equals(this.bord_MtBordHT)) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                msg = msg.replaceAll(MSG_BORD_TYPEBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_BORD_MTHT, this.bord_MtBordHT != null ? this.bord_MtBordHT.toString() : "");
                msg = msg.replaceAll(MSG_BORD_MTTVA, this.bord_MtBordTVA != null ? this.bord_MtBordTVA.toString() : "");
                msg = msg.replaceAll(MSG_BORD_SOMMEHTPIECE, new BigDecimal(this.hashMtsBord.get(BALISE_MT_HT_PIECE).toString()).toString());
                msg = msg.replaceAll(MSG_BORD_SOMMETVAPIECE, "");
                String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Bordereau");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauDepense", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addAll(this.nodesId);
                this.anos.add(ano);
            }
            this.hashMtsBord.clear();
            this.nodesId.clear();
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

