/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.comm;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COMM06B
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(COMM06B.class);
    public static final transient String CTRL_ID = "COMM06B";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private static final String CHEMIN_FIN = "PES_Aller/";
    private static final String ON_RETURN_ANOMALIES = "PES_Aller/";
    private String PAR1 = "";
    private String PAR2 = "";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String finjur = "";
    private String finjur_NodeId = "";
    private boolean finjur_present = false;
    private boolean first_bordereau = false;
    private static final String MSG_FINJUR = "#FINJUR#";
    private static final String MSG_FINJUR_PARAM = "#FINJUR_PARAM#";
    private static final String MSG_ERREUR = "#ERREUR#";
    private static final String RECETTE = "PES_RecetteAller";
    private static final String DEPENSE = "PES_DepenseAller";
    private boolean depense = false;
    private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_FINJUR = "/EnTetePES/FinJur/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In COMM06B");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.indexOf(DEPENSE) != -1) {
            this.depense = true;
        }
        if (xpath.indexOf(RECETTE) != -1) {
            this.depense = false;
        }
        if (xpath.endsWith(CHEMIN_FINJUR)) {
            this.finjur = atts.getValue("V");
            this.finjur_NodeId = atts.getValue("ano:node-id");
            this.finjur_present = true;
        }
        if (!this.first_bordereau) {
            if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
                this.bord_TypBord = "";
                this.bord_IdBord = "";
                this.bord_Exer = "";
            }
            if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
                this.bord_Exer = atts.getValue("V");
            }
            if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
                this.bord_IdBord = atts.getValue("V");
            }
            if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
                this.bord_TypBord = atts.getValue("V");
                this.first_bordereau = true;
            }
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.equals("PES_Aller/")) {
            this.PAR1 = (String)this.hParams.get("nomencl");
            if (this.hParams.get("finJur") != null) {
                this.PAR2 = (String)this.hParams.get("finJur");
            }
            boolean err = false;
            String erreur = "";
            if (!(!this.PAR1.equals("M21") || this.finjur_present && this.finjur.equals(this.PAR2))) {
                err = true;
                erreur = "Pour une M21, le finess juridique doit \u00eatre pr\u00e9sent dans le flux et correspondre au param\u00e9trage.";
            }
            if (!this.PAR1.equals("M21") && this.finjur_present) {
                err = true;
                erreur = "Le finess juridique ne doit \u00eatre pr\u00e9sent que pour les M21.";
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_ERREUR, erreur);
                msg = msg.replaceAll(MSG_FINJUR, this.finjur);
                msg = msg.replaceAll(MSG_FINJUR_PARAM, this.PAR2);
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Bordereau");
                xslParams.put("mandatId", "");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), this.depense ? DEPENSE : RECETTE, this.depense ? "BordereauDepense" : "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.finjur_NodeId));
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

