/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int read() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException ex) {
            return -1;
        }
    }

    public int available() throws IOException {
        return this.buffer.limit() - this.buffer.position();
    }

    public synchronized void reset() throws IOException {
        this.buffer.reset();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.buffer.mark();
    }

    public long skip(long n) throws IOException {
        int old_pos = this.buffer.position();
        int new_pos = old_pos + (int)n;
        if (new_pos >= this.buffer.limit()) {
            new_pos = this.buffer.limit() - 1;
        }
        this.buffer.position(new_pos);
        return new_pos - old_pos;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        len = Math.min(len, this.available());
        this.buffer.get(b, off, len);
        return len;
    }
}

