/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.MYSQL_TIME;
import com.mysql.embedded.api.stmt;
import com.mysql.embedded.jdbc.BindArray;
import com.mysql.embedded.jdbc.MyPreparedStatement;
import com.mysql.embedded.jdbc.MyResultSet;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class MyPreparedResultSet
extends MyResultSet
implements ResultSet {
    protected BindArray resultColumns;
    protected static final ByteOrder DATE_BYTE_ORDER = ByteOrder.nativeOrder();

    public MyPreparedResultSet(MyPreparedStatement aStatement, boolean wasStored) throws SQLException {
        this.statement = aStatement;
        super.setup(this.statement, this.statement.connection, this.preparedStatement().columnCount, this.statement.stored || wasStored, this.statement.maxRows, 0L);
        this.resultColumns = this.preparedStatement().resultColumns;
        this.reset(wasStored);
    }

    protected void reset(boolean wasStored) throws SQLException {
        if (this.stored && !wasStored) {
            stmt.mysql_stmt_store_result(this.preparedStatement().statementHandle);
        }
        stmt.mysql_stmt_bind_result(this.preparedStatement().statementHandle, this.resultColumns.nativeAddress);
        this.currentRowNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            stmt.mysql_stmt_free_result(this.preparedStatement().statementHandle);
        }
        finally {
            super.close();
        }
    }

    public boolean isClosed() {
        return this.resultColumns == null;
    }

    public boolean next() throws SQLException {
        boolean result = stmt.mysql_stmt_fetch(this.preparedStatement().statementHandle);
        if (result) {
            ++this.currentRowNum;
            for (int i = 0; i < this.resultColumns.size(); ++i) {
                if (!this.resultColumns.exceedsCapacity(i)) continue;
                this.resultColumns.fetchRest(i, this.preparedStatement().statementHandle);
            }
        }
        return result;
    }

    public boolean wasNull() throws SQLException {
        return this.resultColumns.isNull(this.fieldIndex - 1);
    }

    protected ByteBuffer getByteBuffer(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getByteBuffer(this.fieldIndex - 1);
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getByte(this.fieldIndex - 1);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getDouble(this.fieldIndex - 1);
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getFloat(this.fieldIndex - 1);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getInt(this.fieldIndex - 1);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getLong(this.fieldIndex - 1);
    }

    public short getShort(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getShort(this.fieldIndex - 1);
    }

    public boolean absolute(int row) throws SQLException {
        if (row - 1 == this.currentRowNum) {
            return this.next();
        }
        if (this.stored) {
            this.currentRowNum = row - 1;
            stmt.mysql_stmt_data_seek(this.preparedStatement().statementHandle, this.currentRowNum);
            return this.next();
        }
        if (this.currentRowNum < row - 1) {
            while (this.currentRowNum < row - 1) {
                if (this.next()) continue;
                return false;
            }
            return this.next();
        }
        throw new SQLException("can't scroll");
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getByte(this.fieldIndex - 1) != 0;
    }

    protected MYSQL_TIME getDateParts(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getDateParts(this.fieldIndex - 1);
    }

    public String getString(int columnIndex) throws SQLException {
        this.fieldIndex = columnIndex;
        return this.resultColumns.getString(this.fieldIndex - 1);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.preparedStatement().getMetaData();
    }

    private final MyPreparedStatement preparedStatement() {
        return (MyPreparedStatement)this.statement;
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        MYSQL_TIME parts = this.getDateParts(columnIndex);
        return MyPreparedResultSet.getTime(parts, cal);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        MYSQL_TIME parts = this.getDateParts(columnIndex);
        return MyPreparedResultSet.getDate(parts, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        MYSQL_TIME parts = this.getDateParts(columnIndex);
        return MyPreparedResultSet.getTimestamp(parts, cal);
    }

    public static Date getDate(MYSQL_TIME parts, Calendar cal) {
        if (parts == null) {
            return null;
        }
        cal.set(1, parts.getYear());
        cal.set(2, 0 + Math.max(0, parts.getMonth() - 1));
        cal.set(5, Math.max(1, parts.getDay()));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long millis = cal.getTimeInMillis();
        return new Date(millis);
    }

    public static Time getTime(MYSQL_TIME parts, Calendar cal) {
        if (parts == null) {
            return null;
        }
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, parts.getDay());
        cal.set(12, parts.getMinute());
        cal.set(13, parts.getSecond());
        cal.set(14, parts.getSecondPart());
        long millis = cal.getTimeInMillis();
        return new Time(millis);
    }

    public static Timestamp getTimestamp(MYSQL_TIME parts, Calendar cal) {
        if (parts == null) {
            return null;
        }
        cal.set(1, parts.getYear());
        cal.set(2, 0 + Math.max(0, parts.getMonth() - 1));
        cal.set(5, Math.max(1, parts.getDay()));
        cal.set(11, parts.getHour());
        cal.set(12, parts.getMinute());
        cal.set(13, parts.getSecond());
        cal.set(14, parts.getSecondPart());
        long millis = cal.getTimeInMillis();
        return new Timestamp(millis);
    }
}

