/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.plugins.SearchPlugin;

public class SqlGenericSearchPlugin
extends SearchPlugin {
    public static final transient String PROPERTY_REQUEST = "request";
    public static final transient String PROPERTY_XPATH = "xpath";
    private String request;
    private String xpath;
    private MySqlDataLayer layer = null;
    private TDocument pc = null;
    private TEtat ec = null;

    public SqlGenericSearchPlugin(XemeliosUser user) {
        super(user);
    }

    public DataResultSet getResultSet() throws Exception {
        this.computeParameters();
        ListeResultatModel lrm = this.getElementModel().getListeResultat();
        return new MySqlDataResultSet(this.getElementModel(), this.getCollectivite(), this.getBudget(), this.xpath, this.getParameterizedRequest(this.request), lrm, this.layer, this.getUser());
    }

    public void computeParameters() throws Exception {
        for (PropertyModel pm : this.getPluginModel().getProperties()) {
            if (PROPERTY_REQUEST.equals(pm.getName())) {
                this.request = pm.getValue();
                continue;
            }
            if (!PROPERTY_XPATH.equals(pm.getName())) continue;
            this.xpath = pm.getValue();
        }
        try {
            this.layer = (MySqlDataLayer)DataLayerManager.getImplementation();
            this.pc = this.layer.getPersistenceConfig(this.getDocumentModel(), this.getUser()).getLayer(this.layer.getLayerName()).getDocument(this.getDocumentModel().getId());
            this.ec = this.pc.getEtat(this.getEtatModel().getId());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getParameterizedRequest(String rq) throws DataConfigurationException {
        String data = rq;
        int posParam = data.indexOf("${");
        while (posParam >= 0) {
            int posEnd = data.indexOf(125, posParam);
            if (posEnd < 0) {
                throw new DataConfigurationException("Invalid request: " + rq);
            }
            String paramName = data.substring(posParam + 2, posEnd);
            String paramValue = null;
            if (paramName.startsWith("table-")) {
                String typeTable = paramName.substring(6);
                if (!typeTable.startsWith("index-")) throw new DataConfigurationException("can only deal with index tables: ${" + paramName + "}");
                String indexId = typeTable.substring(6);
                paramValue = this.ec.getIndexTable(indexId).getBaseName();
            } else if (paramName.equals("collectivite")) {
                paramValue = this.getCollectivite().key;
            } else {
                if (!paramName.equals("budget")) throw new DataConfigurationException("can only deal with tables parameters: ${" + paramName + "}");
                paramValue = this.getBudget().key;
            }
            if (paramValue == null) {
                throw new DataConfigurationException("no value found for param ${" + paramName + "}");
            }
            data = data.replaceAll("\\$\\{" + paramName + "\\}", paramValue);
            posParam = data.indexOf("${");
        }
        int pos = data.indexOf("##");
        while (pos >= 0) {
            int endPos = data.indexOf("##", pos + 2);
            if (endPos < 0) {
                throw new DataConfigurationException("invalid expression near " + data.substring(pos));
            }
            String pattern = data.substring(pos, endPos + 2);
            String paramName = pattern.substring(2, pattern.length() - 2);
            String paramValue = (String)this.getParameters().get(paramName);
            data = paramValue != null ? data.replace(pattern, paramValue) : data.replace(pattern, "\"\"");
            pos = data.indexOf("##");
        }
        return data;
    }
}

