/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.data.CachedData;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataHandler;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MySqlDataResultSetDocGenerator
implements DataResultSet {
    private static Logger logger = Logger.getLogger(MySqlDataResultSetDocGenerator.class);
    protected ElementModel elementModel;
    protected Pair collectivite;
    protected Pair budget;
    protected String xPath;
    protected String sql;
    protected ListeResultatModel lrm;
    protected MySqlDataLayer impl;
    protected File xslFile = null;
    protected int cacheSize = 100;
    protected HashMap<String, Document> cachedDocuments;
    protected ResultSet rs;
    protected int currentPage = 0;
    protected NodeList currentList = null;
    protected Document currentDoc = null;
    protected ResultSetMetaData rsmd = null;
    protected Transformer transformer = null;
    protected Document sourceDoc;
    protected XPath xp;
    protected int currentItemInList = -1;
    protected int estimatedSize = -1;
    protected String currentDocId;
    protected int currentCount = 0;
    protected boolean hasNextItem = false;
    protected CachedData cache = null;
    protected int estimatedPageCount = -1;
    protected int pageSize = 0;
    protected Connection conToRelease = null;

    public MySqlDataResultSetDocGenerator(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, String sql, ListeResultatModel lrm, MySqlDataLayer impl, File xslFile) throws SQLException, DataConfigurationException {
        this.xslFile = xslFile;
        this.elementModel = elementModel;
        this.collectivite = collectivite;
        this.budget = budget;
        this.xPath = xPath;
        this.sql = sql;
        this.lrm = lrm;
        this.impl = impl;
        TransformerFactory tf = TransformerFactoryImpl.newInstance();
        try {
            this.transformer = tf.newTransformer(new StreamSource(new FileInputStream(xslFile)));
            this.sourceDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.sourceDoc.appendChild(this.sourceDoc.createElement("document"));
            XPathFactory xpf = XPathFactory.newInstance();
            this.xp = xpf.newXPath();
            this.xp.setNamespaceContext((NamespaceContext)elementModel.getParent().getParent().getNamespaces());
        }
        catch (Exception ex) {
            logger.error((Object)"in <init>", (Throwable)ex);
        }
        this.cacheSize = elementModel.getMaxDisplay();
        this.cachedDocuments = new HashMap();
        this.executeRequest();
    }

    public int getCount() {
        return this.estimatedSize;
    }

    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    public boolean hasNextPage() {
        return this.currentPage < this.getEstimatedPageCount();
    }

    public boolean hasPreviousPage() {
        return this.currentPage > 0;
    }

    public void setEnvironment(ListeResultatModel lrm, CachedData cache) {
        this.lrm = lrm;
        this.cache = cache;
    }

    public ListeResultatModel getListeResultatModel() {
        return this.lrm;
    }

    public void setListeResultatModel(ListeResultatModel l) {
        this.lrm = l;
    }

    public boolean hasNext() {
        return this.hasNextItem;
    }

    public EtatModel getEtatModel() {
        return this.elementModel.getParent();
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void nextPage() throws DataAccessException, DataConfigurationException {
        if (this.hasNextPage()) {
            ++this.currentPage;
            this.currentList = null;
            if (this.rs != null) {
                this.resetResultSet();
            }
            try {
                this.executeRequest();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void lastPage() throws DataAccessException, DataConfigurationException {
        if (this.hasNextPage()) {
            this.currentPage = this.getEstimatedPageCount() - 1;
            this.currentList = null;
            if (this.rs != null) {
                this.resetResultSet();
            }
            try {
                this.executeRequest();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void previousPage() throws DataAccessException, DataConfigurationException {
        if (this.hasPreviousPage()) {
            --this.currentPage;
            this.currentList = null;
            if (this.rs != null) {
                this.resetResultSet();
            }
            try {
                this.executeRequest();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void firstPage() throws DataAccessException, DataConfigurationException {
        this.currentPage = 0;
        this.currentList = null;
        if (this.rs != null) {
            this.resetResultSet();
        }
        try {
            this.executeRequest();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
    }

    public void setPage(int page) throws DataAccessException, DataConfigurationException {
        this.currentPage = page;
        this.currentList = null;
        if (this.rs != null) {
            this.resetResultSet();
        }
        try {
            this.executeRequest();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
    }

    public int getEstimatedPageCount() {
        if (this.estimatedPageCount == -1) {
            if (this.cacheSize == 0 || this.estimatedSize == 0) {
                this.estimatedPageCount = 0;
            } else {
                this.estimatedPageCount = this.estimatedSize / this.cacheSize;
                if (this.estimatedSize % this.cacheSize > 0) {
                    ++this.estimatedPageCount;
                }
            }
        }
        return this.estimatedPageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public Document getDocument(String docId) throws DataConfigurationException, DataAccessException {
        return this.cachedDocuments.get(docId);
    }

    public String getDocumentEncoding(String docId) throws DataConfigurationException, DataAccessException {
        return "UTF-8";
    }

    public void clear() {
        this.cleanCaches();
    }

    public DataHandler next() {
        try {
            if (this.currentList == null) {
                this.currentDoc = this.getNextDoc();
                this.currentList = (NodeList)this.xp.evaluate(this.xPath, this.currentDoc, XPathConstants.NODESET);
                this.currentItemInList = -1;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"in next()", (Throwable)ex);
        }
        Element el = null;
        try {
            el = (Element)this.currentList.item(++this.currentItemInList);
        }
        catch (IndexOutOfBoundsException iEx) {
        }
        catch (Exception ex) {
            logger.error((Object)this.toString(), (Throwable)ex);
        }
        if (this.currentItemInList == this.currentList.getLength() - 1) {
            this.currentList = null;
            boolean bl = this.hasNextItem = this.currentCount < this.pageSize;
        }
        if (el != null) {
            return new DataHandler(this.lrm, el, (DataResultSet)this, this.currentDocId, this.cache);
        }
        this.hasNextItem = false;
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("this operation is not allowed on MySqlDataResultSetDocGenerator");
    }

    private void cleanAllCaches() {
        if (this.cache != null) {
            this.cache.flush();
        }
        if (this.cachedDocuments != null) {
            this.cachedDocuments.clear();
        }
    }

    protected void cleanCaches() {
        if (this.cache != null) {
            this.cache.flush();
        }
    }

    protected void executeRequest() throws SQLException {
        StringBuffer request = new StringBuffer();
        request.append("SELECT SQL_CALC_FOUND_ROWS ").append(this.sql.substring(6)).append(" LIMIT ");
        request.append(this.currentPage * this.cacheSize).append(", ").append((this.currentPage + 1) * this.cacheSize);
        this.rs = this.impl.execute(request.toString());
        this.hasNextItem = true;
        this.currentCount = 0;
        this.cleanAllCaches();
        this.rsmd = this.rs.getMetaData();
        this.conToRelease = this.rs.getStatement().getConnection();
        if (this.estimatedSize == -1) {
            Statement ps = this.conToRelease.createStatement();
            ResultSet rs2 = ps.executeQuery("SELECT FOUND_ROWS()");
            if (rs2.next()) {
                this.estimatedSize = rs2.getInt(1);
                this.getEstimatedPageCount();
            }
            rs2.close();
            ps.close();
        }
        this.pageSize = this.currentPage == this.getEstimatedPageCount() - 1 ? this.estimatedSize % this.cacheSize : this.cacheSize;
    }

    protected Document getNextDoc() throws SQLException, TransformerException {
        if (this.rs == null) {
            this.executeRequest();
        }
        if (this.rs.next()) {
            ++this.currentCount;
            this.currentDocId = Integer.toString(this.currentCount);
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String pName = this.rsmd.getColumnName(i);
                String pValue = this.rs.getString(pName);
                this.transformer.setParameter(pName, pValue);
            }
            DOMResult dr = new DOMResult();
            this.transformer.transform(new DOMSource(this.sourceDoc), dr);
            Document doc = (Document)dr.getNode();
            this.cachedDocuments.put(this.currentDocId, doc);
            return doc;
        }
        this.impl.releaseConnection(this.conToRelease);
        this.conToRelease = null;
        return null;
    }

    protected void finalize() throws Throwable {
        if (this.conToRelease != null) {
            this.impl.releaseConnection(this.conToRelease);
        }
        this.conToRelease = null;
        super.finalize();
    }

    protected void resetResultSet() {
        try {
            this.rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = null;
        this.impl.releaseConnection(this.conToRelease);
        this.conToRelease = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("cacheSize=").append(this.cacheSize).append("\ncurrentCount=").append(this.currentCount).append("\ncurrentItemInList=").append(this.currentItemInList).append("\ncurrentPage=").append(this.currentPage).append("\nestimatedPageCount=").append(this.estimatedPageCount).append("\nestimatedSize=").append(this.estimatedSize).append("\npageSize=").append(this.pageSize);
        return sb.toString();
    }
}

