/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.MYSQL_FIELD;
import com.mysql.embedded.api.api;
import com.mysql.embedded.jdbc.MySqlTypes;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class MyParameterMetaData
implements ParameterMetaData {
    protected long resHandle;
    boolean deallocHandle;
    protected MYSQL_FIELD[] fields;

    public MyParameterMetaData(long resHandle, int paramCount, boolean deallocHandle) {
        this.resHandle = resHandle;
        this.deallocHandle = deallocHandle;
        this.fields = MYSQL_FIELD.newArray(api.mysql_fetch_fields(resHandle), paramCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.resHandle != 0L && this.deallocHandle) {
                api.mysql_free_result(this.resHandle);
            }
        }
        finally {
            this.resHandle = 0L;
        }
    }

    public int getParameterCount() throws SQLException {
        return this.fields.length;
    }

    public int getParameterMode(int param) throws SQLException {
        return 0;
    }

    public int getParameterType(int param) throws SQLException {
        int mysql_type = this.fields[param].getType();
        return MySqlTypes.asJavaType(mysql_type);
    }

    public int getPrecision(int param) throws SQLException {
        return this.fields[param].getDecimals();
    }

    public int getScale(int param) throws SQLException {
        return this.fields[param].getLength();
    }

    public int isNullable(int param) throws SQLException {
        return 0;
    }

    public boolean isSigned(int param) throws SQLException {
        return false;
    }

    public String getParameterClassName(int param) throws SQLException {
        int mysql_type = this.fields[param].getType();
        int java_type = MySqlTypes.asJavaType(mysql_type);
        return MySqlTypes.getJavaClassName(java_type);
    }

    public String getParameterTypeName(int param) throws SQLException {
        int mysql_type = this.fields[param].getType();
        return MySqlTypes.getMysqlTypeName(mysql_type);
    }

    protected int findColumn(String columnName) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        return -1;
    }
}

