/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.MYSQL_BIND;
import com.mysql.embedded.api.MYSQL_TIME;
import com.mysql.embedded.api.enum_field_types;
import com.mysql.embedded.api.res;
import com.mysql.embedded.api.stmt;
import com.mysql.embedded.jdbc.MyPreparedResultSet;
import com.mysql.embedded.jdbc.MyPreparedStatement;
import com.mysql.embedded.jdbc.MyResultSetMetaData;
import com.mysql.embedded.util.ByteBufferOutputStream;
import com.mysql.embedded.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BindArray
implements enum_field_types {
    protected MyPreparedStatement statement;
    protected int n;
    protected ByteBuffer bindArray;
    protected long nativeAddress;
    protected MYSQL_BIND[] bind;
    protected ByteBuffer[] value;
    protected static final int MIN_BUFFER = MYSQL_TIME.SIZE;

    public BindArray(MyPreparedStatement stm, int n) {
        this.statement = stm;
        this.n = n;
        this.bindArray = ByteBuffer.allocateDirect(MYSQL_BIND.SIZE * n + 4 * n + n);
        this.bindArray.order(ByteOrder.nativeOrder());
        this.nativeAddress = res.get_address(this.bindArray);
        this.bind = new MYSQL_BIND[n];
        this.value = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            this.bind[i] = new MYSQL_BIND(this.bindArray, this.nativeAddress, i * MYSQL_BIND.SIZE);
            this.bind[i].setLengthOffset(n * MYSQL_BIND.SIZE + 4 * i);
            this.bind[i].setIsNullOffset(n * MYSQL_BIND.SIZE + 4 * n + i);
        }
    }

    public void initialize(MyResultSetMetaData meta) {
        block4: for (int i = 0; i < this.n; ++i) {
            int type = meta.getMySqlColumnType(i + 1);
            int size = meta.getLength(i + 1);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: {
                    this.allocateBuffer(i, type, MIN_BUFFER);
                    continue block4;
                }
                case 252: {
                    if (size < 0) {
                        size = 4096;
                    }
                    this.allocateBuffer(i, type, Math.min(size, 4096));
                    continue block4;
                }
                default: {
                    if (size < 0) {
                        throw new IllegalStateException(size + " < 0");
                    }
                    this.allocateBuffer(i, type, size);
                }
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.n; ++i) {
            this.bind[i].setNull(true);
            this.bind[i].setBufferPtr(0L);
            this.value[i] = null;
        }
    }

    public void close() {
        this.bindArray = null;
        this.bind = null;
        this.value = null;
    }

    public int size() {
        return this.n;
    }

    public int getBufferType(int i) {
        return this.bind[i].getBufferType();
    }

    public boolean isNull(int i) {
        return this.bind[i].isNull();
    }

    public boolean isUnsigned(int i) {
        return this.bind[i].isUnsigned();
    }

    public int getLength(int i) {
        return this.bind[i].getLength();
    }

    public int getBufferLength(int i) {
        return this.bind[i].getBufferLength();
    }

    public void setNull(int i, int type) {
        this.bind[i].setNull(true);
        this.bind[i].setBufferType(type);
    }

    public ByteBuffer allocateBuffer(int i, int type, int capacity) {
        if (this.value[i] == null || this.value[i].capacity() < capacity) {
            this.value[i] = ByteBuffer.allocateDirect(capacity);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_bind(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), type, capacity, this.value[i]);
        } else {
            stmt.set_bind(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), type, capacity, null);
        }
        this.value[i].limit(this.value[i].capacity());
        return this.value[i];
    }

    public void setByte(int i, byte x) {
        if (this.value[i] == null || this.value[i].capacity() < 1) {
            this.value[i] = ByteBuffer.allocateDirect(1);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_byte(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], x);
        } else {
            stmt.set_byte(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, x);
        }
    }

    public void setShort(int i, short x) {
        if (this.value[i] == null || this.value[i].capacity() < 2) {
            this.value[i] = ByteBuffer.allocateDirect(2);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_short(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], x);
        } else {
            stmt.set_short(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, x);
        }
    }

    public void setInt(int i, int x) {
        if (this.value[i] == null || this.value[i].capacity() < 4) {
            this.value[i] = ByteBuffer.allocateDirect(4);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_int(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], x);
        } else {
            stmt.set_int(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, x);
        }
    }

    public void setLong(int i, long x) {
        if (this.value[i] == null || this.value[i].capacity() < 8) {
            this.value[i] = ByteBuffer.allocateDirect(8);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_long(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], x);
        } else {
            stmt.set_long(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, x);
        }
    }

    public void setFloat(int i, float x) {
        if (this.value[i] == null || this.value[i].capacity() < 4) {
            this.value[i] = ByteBuffer.allocateDirect(4);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_float(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], x);
        } else {
            stmt.set_float(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, x);
        }
    }

    public void setDouble(int i, double x) {
        if (this.value[i] == null || this.value[i].capacity() < 8) {
            this.value[i] = ByteBuffer.allocateDirect(8);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_double(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], x);
        } else {
            stmt.set_double(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, x);
        }
    }

    public void setBytes(int i, int type, byte[] x, int len) {
        if (this.value[i] == null || this.value[i].capacity() < len) {
            this.value[i] = ByteBuffer.allocateDirect(len);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_bytes(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], type, x, len);
        } else {
            stmt.set_bytes(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, type, x, len);
        }
    }

    public void setCharBuffer(int i, int type, CharBuffer cbuffer) {
        CharsetEncoder enc = this.statement.connection.charEncoder;
        ByteBuffer bbuffer = this.allocateBuffer(i, type, 3 * cbuffer.limit());
        bbuffer.position(0);
        enc.reset();
        enc.encode(cbuffer, bbuffer, true);
        enc.flush(bbuffer);
        this.bind[i].setLength(bbuffer.position());
    }

    public void setString(int i, int type, String string) {
        this.setCharBuffer(i, type, CharBuffer.wrap(string));
    }

    public void setDirectByteBuffer(int i, int type, ByteBuffer x) {
        x.order(ByteOrder.nativeOrder());
        x.position(0);
        stmt.set_bind(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), type, x.limit(), x);
    }

    public void setInputStream(int i, int type, InputStream value, int length) throws SQLException {
        try {
            ByteBuffer buffer = this.allocateBuffer(i, type, length);
            buffer.position(0);
            ByteBufferOutputStream output = new ByteBufferOutputStream(buffer);
            Streams.copyStream(value, output, length);
        }
        catch (IOException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    public void setReader(int i, int type, Reader value, int length) throws SQLException {
        try {
            ByteBuffer buffer = this.allocateBuffer(i, type, length);
            buffer.position(0);
            ByteBufferOutputStream output = new ByteBufferOutputStream(buffer);
            Streams.copyReader(value, output, (long)length);
        }
        catch (IOException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    public void setDate(int i, int type, Calendar cal) {
        if (this.value[i] == null || this.value[i].capacity() < MYSQL_TIME.SIZE) {
            this.value[i] = ByteBuffer.allocateDirect(MYSQL_TIME.SIZE);
            this.value[i].order(ByteOrder.nativeOrder());
            stmt.set_date(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), this.value[i], type, (short)cal.get(1), (short)(cal.get(2) - 0 + 1), (short)cal.get(5), (short)cal.get(11), (short)cal.get(12), (short)cal.get(13), (short)cal.get(14));
        } else {
            stmt.set_date(this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), null, type, (short)cal.get(1), (short)(cal.get(2) - 0 + 1), (short)cal.get(5), (short)cal.get(11), (short)cal.get(12), (short)cal.get(13), (short)cal.get(14));
        }
    }

    protected static int roundUp(int size) {
        return 4096 * ((size + 4095) / 4096);
    }

    public boolean exceedsCapacity(int i) {
        if (this.bind[i].isNull()) {
            return false;
        }
        return this.bind[i].getLength() > this.value[i].capacity();
    }

    public void fetchRest(int i, long statementHandle) throws SQLException {
        ByteBuffer oldBuffer = this.value[i];
        int oldSize = this.value[i].capacity();
        int len = this.bind[i].getLength();
        if (len <= oldSize) {
            return;
        }
        int capacity = BindArray.roundUp(len);
        this.allocateBuffer(i, this.bind[i].getBufferType(), capacity);
        oldBuffer.position(0);
        oldBuffer.limit(oldSize);
        this.value[i].put(oldBuffer);
        stmt.mysql_stmt_fetch_column(statementHandle, this.nativeAddress + (long)(i * MYSQL_BIND.SIZE), i, oldSize, oldSize);
    }

    public ByteBuffer getByteBuffer(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return null;
        }
        this.value[i].position(0);
        int len = this.bind[i].getLength();
        try {
            this.value[i].limit(len);
        }
        catch (IllegalArgumentException iaex) {
            throw new SQLException("illegal array size " + len);
        }
        return this.value[i];
    }

    public byte getByte(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return 0;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                return this.value[i].get(0);
            }
            case 2: {
                short svalue = this.value[i].getShort(0);
                return this.bind[i].isUnsigned() ? (byte)(0xFF & svalue) : (byte)svalue;
            }
            case 3: {
                int ivalue = this.value[i].getInt(0);
                return this.bind[i].isUnsigned() ? (byte)(0xFF & ivalue) : (byte)ivalue;
            }
            case 8: {
                long lvalue = this.value[i].getLong(0);
                return this.bind[i].isUnsigned() ? (byte)(0xFFL & lvalue) : (byte)lvalue;
            }
            case 4: {
                return (byte)this.value[i].getFloat(0);
            }
            case 5: {
                return (byte)this.value[i].getDouble(0);
            }
            case 0: 
            case 15: 
            case 246: 
            case 253: 
            case 254: {
                return Byte.parseByte(this.getString(i));
            }
        }
        throw new SQLException("invalid conversion");
    }

    public short getShort(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return 0;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                byte bvalue = this.value[i].get(0);
                return this.bind[i].isUnsigned() ? (short)(0xFF & bvalue) : (short)bvalue;
            }
            case 2: {
                return this.value[i].getShort(0);
            }
            case 3: {
                int ivalue = this.value[i].getInt(0);
                return this.bind[i].isUnsigned() ? (short)(0xFFFF & ivalue) : (short)ivalue;
            }
            case 8: {
                long lvalue = this.value[i].getLong(0);
                return this.bind[i].isUnsigned() ? (short)(0xFFFFL & lvalue) : (short)lvalue;
            }
            case 4: {
                return (short)this.value[i].getFloat(0);
            }
            case 5: {
                return (short)this.value[i].getDouble(0);
            }
            case 0: 
            case 15: 
            case 246: 
            case 253: 
            case 254: {
                return Short.parseShort(this.getString(i));
            }
        }
        throw new SQLException("invalid conversion");
    }

    public int getInt(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return 0;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                int bvalue = this.value[i].get(0);
                return this.bind[i].isUnsigned() ? 0xFF & bvalue : bvalue;
            }
            case 2: {
                int svalue = this.value[i].getShort(0);
                return this.bind[i].isUnsigned() ? 0xFFFF & svalue : svalue;
            }
            case 3: {
                return this.value[i].getInt(0);
            }
            case 8: {
                long lvalue = this.value[i].getLong(0);
                return this.bind[i].isUnsigned() ? (int)(0xFFFFFFFFFFFFFFFFL & lvalue) : (int)lvalue;
            }
            case 4: {
                return (int)this.value[i].getFloat(0);
            }
            case 5: {
                return (int)this.value[i].getDouble(0);
            }
            case 0: 
            case 15: 
            case 246: 
            case 253: 
            case 254: {
                return Integer.parseInt(this.getString(i));
            }
        }
        throw new SQLException("invalid conversion");
    }

    public long getLong(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return 0L;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                byte bvalue = this.value[i].get(0);
                return this.bind[i].isUnsigned() ? (long)(0xFF & bvalue) : (long)bvalue;
            }
            case 2: {
                short svalue = this.value[i].getShort(0);
                return this.bind[i].isUnsigned() ? (long)(0xFFFF & svalue) : (long)svalue;
            }
            case 3: {
                int ivalue = this.value[i].getInt(0);
                return this.bind[i].isUnsigned() ? (long)(0xFFFFFFFF & ivalue) : (long)ivalue;
            }
            case 8: {
                return this.value[i].getLong(0);
            }
            case 4: {
                return (long)this.value[i].getFloat(0);
            }
            case 5: {
                return (long)this.value[i].getDouble(0);
            }
            case 0: 
            case 15: 
            case 246: 
            case 253: 
            case 254: {
                return Long.parseLong(this.getString(i));
            }
        }
        throw new SQLException("invalid conversion");
    }

    public float getFloat(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return 0.0f;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                byte bvalue = this.value[i].get(0);
                return this.bind[i].isUnsigned() ? (float)(0xFF & bvalue) : (float)bvalue;
            }
            case 2: {
                short svalue = this.value[i].getShort(0);
                return this.bind[i].isUnsigned() ? (float)(0xFFFF & svalue) : (float)svalue;
            }
            case 3: {
                int ivalue = this.value[i].getInt(0);
                return this.bind[i].isUnsigned() ? (float)(0xFFFFFFFF & ivalue) : (float)ivalue;
            }
            case 8: {
                return this.value[i].getLong(0);
            }
            case 4: {
                return this.value[i].getFloat(0);
            }
            case 5: {
                return (float)this.value[i].getDouble(0);
            }
            case 0: 
            case 15: 
            case 246: 
            case 253: 
            case 254: {
                return Float.parseFloat(this.getString(i));
            }
        }
        throw new SQLException("invalid conversion");
    }

    public double getDouble(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return 0.0;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                byte bvalue = this.value[i].get(0);
                return this.bind[i].isUnsigned() ? (double)(0xFF & bvalue) : (double)bvalue;
            }
            case 2: {
                short svalue = this.value[i].getShort(0);
                return this.bind[i].isUnsigned() ? (double)(0xFFFF & svalue) : (double)svalue;
            }
            case 3: {
                int ivalue = this.value[i].getInt(0);
                return this.bind[i].isUnsigned() ? (double)(0xFFFFFFFF & ivalue) : (double)ivalue;
            }
            case 8: {
                return this.value[i].getLong(0);
            }
            case 4: {
                return this.value[i].getFloat(0);
            }
            case 5: {
                return this.value[i].getDouble(0);
            }
            case 0: 
            case 15: 
            case 246: 
            case 253: 
            case 254: {
                return Double.parseDouble(this.getString(i));
            }
        }
        throw new SQLException("invalid conversion");
    }

    public MYSQL_TIME getDateParts(int i) {
        if (this.bind[i].isNull()) {
            return null;
        }
        MYSQL_TIME time = this.statement.connection.mysqlTime;
        time.attach(this.value[i], 0L, 0);
        return time;
    }

    public String getString(int i) throws SQLException {
        if (this.bind[i].isNull()) {
            return null;
        }
        switch (this.bind[i].getBufferType()) {
            case 1: {
                return String.valueOf(this.getByte(i));
            }
            case 2: {
                return String.valueOf(this.getShort(i));
            }
            case 3: {
                return String.valueOf(this.getInt(i));
            }
            case 8: {
                return String.valueOf(this.getLong(i));
            }
            case 4: {
                return String.valueOf(this.getFloat(i));
            }
            case 0: 
            case 15: 
            case 246: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                return this.statement.connection.decodeString(this.value[i], this.bind[i].getLength());
            }
            case 11: {
                Time dt = MyPreparedResultSet.getTime(this.getDateParts(i), this.statement.connection.utcCalendar);
                return this.statement.connection.timeFormat.format(dt);
            }
            case 10: {
                Date dt = MyPreparedResultSet.getDate(this.getDateParts(i), this.statement.connection.utcCalendar);
                return this.statement.connection.dateFormat.format(dt);
            }
            case 7: 
            case 12: {
                Timestamp dt = MyPreparedResultSet.getTimestamp(this.getDateParts(i), this.statement.connection.utcCalendar);
                return this.statement.connection.timestampFormat.format(dt);
            }
            case 13: {
                Date dt = MyPreparedResultSet.getDate(this.getDateParts(i), this.statement.connection.utcCalendar);
                return this.statement.connection.yearFormat.format(dt);
            }
        }
        throw new SQLException("invalid conversion");
    }
}

