/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.controls.etatFrais.som;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOM01
extends AbstractUnitControl {
    protected StringBuilder charsBuffer = new StringBuilder();
    private static final Logger logger = Logger.getLogger(SOM01.class);
    public static final transient String CTRL_ID = "SOM01";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private ArrayList<Node> nodesId = new ArrayList();
    private String ID_Invoice_Unique = "";
    private static final String FIN_INVOICE = "EtatsFrais/Invoice/";
    private static final String ON_RETURN_ANOMALIES = "EtatsFrais/Invoice/";
    private String om_IssueDate;
    private String om_IdOm;
    private String om_TypEtatFrais;
    private BigDecimal om_LegalMonetaryTotal;
    private static final String BALISE_MONTANT_LIGNE = "LineExtensionAmount";
    private static DecimalFormat df;
    private Hashtable<String, BigDecimal> hashMtsINVOICE = new Hashtable();
    private static final String MSG_CBC_ID = "#CBC_ID#";
    private static final String MSG_CBC_ISSUEDATE = "#CBC_ISSUEDATE#";
    private static final String MSG_CBC_INVOICETYPECODE = "#CBC_INVOICETYPECODE#";
    private static final String MSG_CAC_LEGAL_MONETARY_TOTAL = "#CAC_LEGAL_MONETARY_TOTAL#";
    private static final String MSG_SOMME_CBC_LINEEXTENSIONAMOUNT = "#SOMME_CBC_LINEEXTENSIONAMOUNT#";
    private static final String CHEMIN_INVOICE = "EtatsFrais/Invoice/";
    private static final String CHEMIN_INVOICEDATE = "EtatsFrais/Invoice/IssueDate/";
    private static final String CHEMIN_INVOICE_IDINVOICE = "EtatsFrais/Invoice/ID/";
    private static final String CHEMIN_INVOICE_TYPINVOICE = "EtatsFrais/Invoice/InvoiceTypeCode/";
    private static final String CHEMIN_INVOICE_MONTANTINVOICE = "EtatsFrais/Invoice/LegalMonetaryTotal/LineExtensionAmount/";
    private static final String CHEMIN_INVOICE_MONTANTLIGNE = "EtatsFrais/Invoice/InvoiceLine/LineExtensionAmount/";

    protected Logger getLogger() {
        return logger;
    }

    protected String getCtrlId() {
        return CTRL_ID;
    }

    public void startDocument() throws SAXException {
        logger.info((Object)"In SOM01");
        df = new DecimalFormat("############0.00");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith("EtatsFrais/Invoice/")) {
            this.anos = new Vector();
            this.om_LegalMonetaryTotal = new BigDecimal(0);
            this.ID_Invoice_Unique = atts.getValue("ano:unique-id");
        }
        if (xpath.endsWith(CHEMIN_INVOICE_MONTANTINVOICE) || xpath.endsWith(CHEMIN_INVOICE_MONTANTLIGNE)) {
            this.nodesId.add(new Node(atts.getValue("ano:node-id")));
        }
        this.charsBuffer.delete(0, this.charsBuffer.length());
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        String value = this.charsBuffer.toString();
        if (xpath.endsWith(CHEMIN_INVOICEDATE)) {
            this.om_IssueDate = value;
        }
        if (xpath.endsWith(CHEMIN_INVOICE_IDINVOICE)) {
            this.om_IdOm = value;
        }
        if (xpath.endsWith(CHEMIN_INVOICE_TYPINVOICE)) {
            this.om_TypEtatFrais = value;
        }
        if (xpath.endsWith(CHEMIN_INVOICE_MONTANTINVOICE)) {
            try {
                this.om_LegalMonetaryTotal = new BigDecimal(value);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (xpath.endsWith(CHEMIN_INVOICE_MONTANTLIGNE)) {
            if (this.hashMtsINVOICE.get(BALISE_MONTANT_LIGNE) != null) {
                try {
                    BigDecimal oldValue = this.hashMtsINVOICE.get(BALISE_MONTANT_LIGNE);
                    BigDecimal newValue = new BigDecimal(value).add(oldValue);
                    this.hashMtsINVOICE.put(BALISE_MONTANT_LIGNE, newValue);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.debug((Object)"Pb de parsing de float dans SOM01.");
                }
            } else {
                BigDecimal dvalue = new BigDecimal(value);
                this.hashMtsINVOICE.put(BALISE_MONTANT_LIGNE, dvalue);
            }
        }
        if (xpath.endsWith("EtatsFrais/Invoice/")) {
            if (this.om_LegalMonetaryTotal.compareTo(this.hashMtsINVOICE.get(BALISE_MONTANT_LIGNE)) != 0) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_CBC_ID, this.om_IdOm);
                msg = msg.replaceAll(MSG_CBC_ISSUEDATE, this.om_IssueDate);
                msg = msg.replaceAll(MSG_CBC_INVOICETYPECODE, this.om_TypEtatFrais);
                msg = msg.replaceAll(MSG_CAC_LEGAL_MONETARY_TOTAL, this.om_LegalMonetaryTotal != null ? this.om_LegalMonetaryTotal.toString() : "");
                msg = msg.replaceAll(MSG_SOMME_CBC_LINEEXTENSIONAMOUNT, new BigDecimal(this.hashMtsINVOICE.get(BALISE_MONTANT_LIGNE).toString()).toString());
                String path = "@ano:unique-id='" + this.ID_Invoice_Unique + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Invoice " + this.om_IdOm;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(this.getCtrlId()).getId(), this.getDocumentModel().getControlById(this.getCtrlId()).getLibelle(), this.getDocumentModel().getDocumentId(), "EtatFrais", "invoice", this.om_IdOm, localName, libelleLien, msg, this.getDocumentModel().getControlById(this.getCtrlId()).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(this.getCtrlId()).getSeverity(), path, xslParams);
                ano.addAll(this.nodesId);
                this.anos.add(ano);
            }
            this.hashMtsINVOICE.clear();
            this.nodesId.clear();
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) throws SAXException {
        this.charsBuffer.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

